/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.tml.vncviewer.graphics.AbstractPaintStrategy;
import org.eclipse.tml.vncviewer.graphics.IPainterContext;
import org.eclipse.tml.vncviewer.network.RectHeader;

public class ZlibPaintStrategy
extends AbstractPaintStrategy {
    public ZlibPaintStrategy(IPainterContext context) {
        super(context);
    }

    public void processRectangle(RectHeader rh, DataInputStream in) throws Exception {
        int x = rh.getX();
        int y = rh.getY();
        int width = rh.getWidth();
        int height = rh.getHeight();
        int compressedDataLength = in.readInt();
        byte[] compressedDataBuffer = new byte[compressedDataLength];
        in.readFully(compressedDataBuffer, 0, compressedDataLength);
        byte[] uncompressedDataBuffer = new byte[width * height * this.getContext().getBytesPerPixel()];
        Inflater zlibInflater = new Inflater();
        zlibInflater.setInput(compressedDataBuffer, 0, compressedDataLength);
        try {
            zlibInflater.inflate(uncompressedDataBuffer, 0, uncompressedDataBuffer.length);
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
        compressedDataBuffer = null;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(uncompressedDataBuffer));
        int[] pixels = new int[width * height];
        IPainterContext pc = this.getContext();
        int i = 0;
        int e = width * height;
        while (i < e) {
            pixels[i] = pc.readPixel(is);
            ++i;
        }
        this.getContext().setPixels(x, y, width, height, pixels, 0);
    }
}

