/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.service.vncviewer.handler;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.handler.IServiceHandler;
import org.eclipse.tml.framework.device.model.handler.ServiceHandler;
import org.eclipse.tml.protocol.PluginProtocolActionDelegate;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.service.vncviewer.VNCViewerServiceResources;
import org.eclipse.tml.vncviewer.vncviews.views.VNCViewerView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VNCViewerServiceHandler
extends ServiceHandler {
    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        ProtocolHandle handle;
        BasePlugin.logInfo((String)(String.valueOf(VNCViewerServiceResources.TML_VNCViewer_Service) + "->" + instance.getName()));
        String host = instance.getProperties().getProperty("host");
        int port = Integer.parseInt(instance.getProperties().getProperty("port"));
        String protoVersion = "VNC 3.3";
        String password = instance.getProperties().getProperty("password");
        try {
            if (instance.getStatus().equals("IDLE-VNC")) {
                VNCViewerView.stop();
                try {
                    handle = VNCViewerView.protocolHandle;
                    PluginProtocolActionDelegate.stopProtocol((ProtocolHandle)handle);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView("org.eclipse.tml.vncviewer.vncviews.views.VNCViewerView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (VNCViewerView.protocolHandle != null) {
            VNCViewerView.stop();
            try {
                PluginProtocolActionDelegate.stopProtocol((ProtocolHandle)VNCViewerView.protocolHandle);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        VNCViewerView.start((String)host, (int)port, (String)protoVersion, (String)password, (boolean)false);
        if (instance.getDeviceTypeId().equals("org.eclipse.tml.device.qemuarm.qemuarmDevice")) {
            try {
                handle = VNCViewerView.protocolHandle;
                ProtocolMessage qemumsg = new ProtocolMessage(4L);
                qemumsg.setFieldValue("downFlag", (Object)1);
                qemumsg.setFieldValue("padding", (Object)0);
                qemumsg.setFieldValue("key", (Object)65507);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
                qemumsg.setFieldValue("key", (Object)65513);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
                qemumsg.setFieldValue("key", (Object)51);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
                qemumsg.setFieldValue("downFlag", (Object)0);
                qemumsg.setFieldValue("key", (Object)65507);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
                qemumsg.setFieldValue("key", (Object)65513);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
                qemumsg.setFieldValue("key", (Object)51);
                PluginProtocolActionDelegate.sendMessageToServer((ProtocolHandle)handle, (ProtocolMessage)qemumsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        BasePlugin.logInfo((String)(String.valueOf(VNCViewerServiceResources.TML_VNCViewer_Service_Update) + "->" + instance.getName()));
        return Status.OK_STATUS;
    }

    public IServiceHandler newInstance() {
        return new VNCViewerServiceHandler();
    }
}

