/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt.img;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.vncviewer.config.IPropertiesFileHandler;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.img.Painter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;

public class SWTRemoteDisplayImg
extends SWTRemoteDisplay {
    public SWTRemoteDisplayImg(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler) {
        this(parent, configProperties, propertiesFileHandler, null);
    }

    public SWTRemoteDisplayImg(Composite parent, Properties configProperties, IPropertiesFileHandler propertiesFileHandler, ISWTPainter painter_) {
        super(parent, configProperties, propertiesFileHandler);
        this.painter = painter_;
        if (this.painter == null) {
            this.painter = new Painter(this);
        }
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                SWTRemoteDisplayImg.this.paintControl(e);
            }
        };
    }

    public synchronized void start(ProtocolHandle handle) throws Exception {
        super.start(handle);
        this.canvas.getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplayImg.this.canvas.addPaintListener(SWTRemoteDisplayImg.this.paintListener);
            }
        });
        ((Painter)this.painter).addSWTRemoteDisplayImg(this);
    }

    public synchronized void stop() {
        super.stop();
        ((Painter)this.painter).removeSWTRemoteDisplayImg(this);
    }

    protected int getCanvasStyle() {
        return 262144;
    }

    public IVNCPainter getPainter() {
        return (Painter)this.painter;
    }

    protected void redrawScreen() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.redraw();
                }
            }
        });
    }

    protected void redrawScreen(int x, int y, int width, int height) {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Canvas c = SWTRemoteDisplayImg.this.getCanvas();
                if (c != null && !c.isDisposed()) {
                    c.redraw(x, y, width, height, false);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.painter != null) {
            ((Painter)this.painter).dispose();
        }
    }

    protected void paintControl(PaintEvent event) {
        ImageData id = this.painter != null ? ((Painter)this.painter).getImageData() : null;
        Image image = null;
        if (id != null) {
            id = id.scaledTo((int)((double)id.width * this.getZoomFactor()), (int)((double)id.height * this.getZoomFactor()));
            image = new Image(event.gc.getDevice(), id);
        }
        event.gc.setBackground(this.canvas.getBackground());
        event.gc.setForeground(this.canvas.getForeground());
        if (image == null) {
            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        } else {
            Rectangle r = image.getBounds();
            int w = Math.min(event.width, r.width);
            int h = Math.min(event.height, r.height);
            event.gc.drawImage(image, event.x, event.y, w, h, event.x, event.y, w, h);
            image.dispose();
        }
    }
}

