/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.network.tcf;

import java.io.IOException;
import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.network.tcf.TCFWrapper;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;

public class TCFProvider
extends AbstractNotifier
implements IConnectionProvider {
    private TCFWrapper connectionWrapper = new TCFWrapper();
    private ILogger logger = LinuxToolsPlugin.getLogger();
    private Thread connectThread = null;
    private Thread sendCommandThread = null;

    public void connect(String host, int port) throws IOException {
        final String hostAux = host;
        final int portAux = port;
        final TCFWrapper connectionWrapperAux = this.connectionWrapper;
        this.connectThread = new Thread(){

            public void run() {
                try {
                    connectionWrapperAux.connect(hostAux, portAux);
                    TCFProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_CONNECT_FINISHED, IConstants.OperationCode.SUCCESS);
                }
                catch (IOException iOException) {
                    TCFProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_CONNECT_ERROR, IConstants.OperationCode.UNEXPECTED_RESULT);
                }
            }
        };
        this.connectThread.start();
    }

    public void disconnect() throws IOException {
        if (this.connectThread != null && this.connectThread.isAlive()) {
            this.connectThread.interrupt();
        }
        if (this.sendCommandThread != null && this.sendCommandThread.isAlive()) {
            this.sendCommandThread.interrupt();
        }
        this.connectionWrapper.disconnect();
        this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_DISCONNECT_FINISHED, IConstants.OperationCode.SUCCESS);
    }

    public StringBuffer getLastResponde() {
        return this.connectionWrapper.getLastResponde();
    }

    public void login(String user, String password) throws IOException {
    }

    public void sendCommand(IConstants.CommandCode cmd, String cmdStr) throws IOException {
        if (IConstants.CommandCode.FETCH_FILE != cmd) {
            return;
        }
        final TCFWrapper connectionWrapperAux = this.connectionWrapper;
        final String path = cmdStr.substring(0, cmdStr.lastIndexOf("/"));
        final String fileName = cmdStr.substring(cmdStr.lastIndexOf("/"));
        this.sendCommandThread = new Thread(){

            public void run() {
                try {
                    if (connectionWrapperAux.fetchFile(path, fileName) != null) {
                        StringBuffer result = connectionWrapperAux.getLastResponde();
                        TCFProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_FINISHED, result);
                    } else {
                        TCFProvider.this.logger.info((Object)"##### NULL ######");
                    }
                }
                catch (IOException iOException) {
                    TCFProvider.this.notifyListeners(IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_ERROR, null);
                }
            }
        };
        this.sendCommandThread.start();
    }

    public void sendData(String out) {
        this.connectionWrapper.sendData(out);
    }

    public void setResponseLength(int maxLength) {
        this.connectionWrapper.setResponseLength(maxLength);
    }
}

