/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.cpuload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.cpuload.Messages;

public class CpuLoadProcessor
extends AbstractNotifier
implements IListener {
    private final String CMD_FETCH_STAT = "/proc/stat";
    private final String PARSE_PATTERN_1 = "cpu(\\d*)(.*)";
    private final String PARSE_PATTERN_2 = "\\s+(\\d+)";
    private final String DATA_FORMAT = "%1$02.1f %%";
    private final String MSG_EXECUTING_COMMAND = Messages.CpuLoadProcessor_Msg_Executing_the_command;
    private final String MSG_GOT_RESULT = Messages.CpuLoadProcessor_Msg_Got_The_Result;
    private final int MAX_COLUMNS = 100;
    private int[][] previousData = null;
    private long[] previousTotal = null;
    private IConnectionProvider connectionProvider = null;
    private ILogger logger = null;

    public CpuLoadProcessor(IConnectionProvider connectionProvider) {
        this.setConnectionProvider(connectionProvider);
        this.logger = LinuxToolsPlugin.getLogger();
    }

    public void gatherData() throws IOException {
        this.connectionProvider.sendCommand(IConstants.CommandCode.FETCH_FILE, "/proc/stat");
        this.logger.debug((Object)(String.valueOf(this.MSG_EXECUTING_COMMAND) + "\n" + "/proc/stat"));
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        if (notifier == this.connectionProvider && event == IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_FINISHED) {
            Object[][] parsedResult = this.parseStat((StringBuffer)result);
            this.notifyListeners(IConstants.EventCode.EVT_PROCESSOR_GATHERDATA_FINISHED, parsedResult);
        }
    }

    public void setConnectionProvider(IConnectionProvider connectionProvider) {
        if (this.connectionProvider != null) {
            this.connectionProvider.removeListener((IListener)this);
        }
        this.connectionProvider = connectionProvider;
        if (this.connectionProvider != null) {
            this.connectionProvider.addListener((IListener)this);
        }
    }

    private Object[][] calculateTimes(String[][] currentDataStr) {
        Object[][] resultStr = null;
        if (currentDataStr == null) {
            currentDataStr = new String[][]{{"0"}};
        }
        if (this.previousData == null) {
            this.previousData = new int[][]{new int[1]};
            this.previousTotal = new long[]{1L};
        }
        if (this.previousData.length != currentDataStr.length || this.previousData[0].length != currentDataStr[0].length) {
            this.previousData = this.String2int(currentDataStr);
            this.previousTotal = new long[this.previousData.length];
            int j = 0;
            while (j < this.previousData.length) {
                long total = 0L;
                int i = 0;
                while (i < this.previousData[0].length) {
                    total += (long)this.previousData[j][i];
                    ++i;
                }
                this.previousTotal[j] = total;
                ++j;
            }
        }
        int[][] currentDataInt = this.String2int(currentDataStr);
        float[][] resultFloat = new float[currentDataStr.length][currentDataStr[0].length];
        int j = 0;
        while (j < currentDataInt.length) {
            long total = 0L;
            int i = 0;
            while (i < currentDataInt[0].length) {
                total += (long)currentDataInt[j][i];
                ++i;
            }
            float deltaTotal = total - this.previousTotal[j];
            this.previousTotal[j] = total;
            int i2 = 0;
            while (i2 < currentDataInt[0].length) {
                float deltaData = currentDataInt[j][i2] - this.previousData[j][i2];
                resultFloat[j][i2] = 0.0f == deltaTotal ? 0.0f : 100.0f * deltaData / deltaTotal;
                ++i2;
            }
            ++j;
        }
        this.previousData = currentDataInt;
        resultStr = this.float2StringFormated(resultFloat, "%1$02.1f %%");
        return resultStr;
    }

    private void copyData(Object[][] target, Object[][] Source) {
        int j = 0;
        while (j < target.length) {
            int i = 1;
            while (i < target[0].length) {
                target[j][i] = Source[j][i - 1];
                ++i;
            }
            ++j;
        }
    }

    private String[][] float2StringFormated(float[][] input, String format) {
        String[][] output = null;
        if (input != null) {
            output = new String[input.length][input[0].length];
            int j = 0;
            while (j < output.length) {
                int i = 0;
                while (i < output[0].length) {
                    output[j][i] = String.format(format, new Float(input[j][i]));
                    ++i;
                }
                ++j;
            }
        }
        return output;
    }

    private Object[][] parseStat(StringBuffer data) {
        Object[][] result;
        this.logger.debug((Object)(String.valueOf(this.MSG_GOT_RESULT) + "\n" + data.toString()));
        int requiredColumns = 0;
        Scanner s1 = new Scanner(data.toString());
        ArrayList<String[]> list = new ArrayList<String[]>();
        while (s1.hasNextLine()) {
            String[] entry = new String[100];
            Scanner s2 = new Scanner(s1.nextLine());
            s2.findInLine("cpu(\\d*)(.*)");
            try {
                result = s2.match();
                entry[0] = result.group(1).trim();
                String aux = result.group(2);
                Scanner s3 = new Scanner(aux);
                entry[1] = s3.findInLine("\\s+(\\d+)").trim();
                s3.match();
                int i = 2;
                while (s3.hasNext() && i < 100) {
                    entry[i] = s3.next().trim();
                    if (i > requiredColumns) {
                        requiredColumns = i;
                    }
                    ++i;
                }
                s3.close();
                if (entry != null) {
                    list.add(entry);
                }
            }
            catch (IllegalStateException illegalStateException) {}
            s2.close();
        }
        s1.close();
        Object[][] dataAux = new String[list.size()][requiredColumns + 1];
        int j = 0;
        while (j < dataAux.length) {
            int i = 0;
            while (i < dataAux[0].length) {
                dataAux[j][i] = ((String[])list.get(j))[i];
                ++i;
            }
            ++j;
        }
        String[][] dataStrippedAux = this.stripFirstColumn((String[][])dataAux);
        result = this.calculateTimes(dataStrippedAux);
        this.copyData(dataAux, result);
        return dataAux;
    }

    private int[][] String2int(String[][] input) {
        int[][] output = null;
        if (input != null) {
            output = new int[input.length][input[0].length];
            int j = 0;
            while (j < output.length) {
                int i = 0;
                while (i < output[0].length) {
                    try {
                        output[j][i] = new Integer(input[j][i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output[j][i] = -1;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return output;
    }

    private String[][] stripFirstColumn(String[][] input) {
        String[][] output = null;
        if (input != null) {
            output = new String[input.length][input[0].length - 1];
            int j = 0;
            while (j < output.length) {
                int i = 0;
                while (i < output[0].length) {
                    output[j][i] = input[j][i + 1];
                    ++i;
                }
                ++j;
            }
        }
        return output;
    }
}

