/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInput;
import java.io.OutputStream;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.vncviewer.network.VNCProtocol;

public class VNCProtocol33
extends VNCProtocol {
    static final String RFB_VERSION = "RFB 003.003\n";
    static final int HANDSHAKE_MESSAGE_SIZE = 12;

    protected String getVersion() {
        return RFB_VERSION;
    }

    protected int[] readSecurityTypes(DataInput in) throws Exception {
        int[] result = null;
        int secType = in.readInt();
        switch (secType) {
            case 0: {
                this.handshakeFail(in);
                break;
            }
            case 1: 
            case 2: {
                result = new int[]{secType};
                break;
            }
            default: {
                throw new Exception("VNC security negotiation error: Unknown security type");
            }
        }
        return result;
    }

    protected void sendSecurityType(OutputStream out, int securityType) throws Exception {
    }

    protected void readAuthenticationResult(DataInput in) throws Exception {
    }

    protected void compareVersion(byte[] b) throws Exception {
        if (!new String(b).equals(RFB_VERSION)) {
            throw new ProtocolException("Wrong protocol version.");
        }
    }

    protected void handShake(DataInput in, OutputStream out) throws Exception {
        byte[] b = new byte[12];
        in.readFully(b, 0, 12);
        this.compareVersion(b);
        out.write(b);
        in.readInt();
    }
}

