/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.model;

import java.util.Comparator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.tml.framework.device.ui.view.model.ViewerInstanceNode;
import org.eclipse.tml.framework.device.ui.view.provider.InstanceMgtViewLabelProvider;

public class InstanceMgtViewComparator
extends ViewerComparator {
    private int columnToSort = -1;
    private boolean isAscending = false;
    private InstanceMgtViewLabelProvider labelProvider;

    public InstanceMgtViewComparator(InstanceMgtViewLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setColumnToSort(int columnIndex) {
        this.columnToSort = columnIndex;
    }

    public void toggleAscending() {
        this.isAscending = !this.isAscending;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public int compare(Viewer treeViewer, Object e1, Object e2) {
        int compareResult;
        if (e1 instanceof ViewerInstanceNode && e2 instanceof ViewerInstanceNode) {
            int columnCount = ((TreeViewer)treeViewer).getTree().getColumnCount();
            if (this.columnToSort < 0 || this.columnToSort > columnCount) {
                compareResult = super.compare(treeViewer, e1, e2);
            } else {
                ViewerInstanceNode node1 = (ViewerInstanceNode)e1;
                ViewerInstanceNode node2 = (ViewerInstanceNode)e2;
                String label1 = this.labelProvider.getText(node1, this.columnToSort);
                String label2 = this.labelProvider.getText(node2, this.columnToSort);
                Comparator comparator = this.getComparator();
                compareResult = this.isAscending ? comparator.compare(label1, label2) : comparator.compare(label2, label1);
            }
        } else {
            compareResult = super.compare(treeViewer, e1, e2);
        }
        return compareResult;
    }
}

