/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.wizard;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.internal.model.MobileDeviceType;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.AbstractMobileInstance;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.ui.DeviceUIResources;
import org.eclipse.tml.framework.device.ui.wizard.NewDeviceMenuWizard;

public class DefaultDeviceTypeMenuWizardPage
extends WizardPage {
    private static final String PROPERTY_ICON = "icon";
    private Text nameText;
    private MobileDeviceType currentDeviceType;
    private TreeViewer deviceTypesTreeViewer;

    protected DefaultDeviceTypeMenuWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected DefaultDeviceTypeMenuWizardPage(String pageName, String currentDeviceTypeId) {
        super(pageName);
        this.setTitle(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_title);
        this.setMessage(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_message);
        Object[] objectArray = DeviceTypeRegistry.getInstance().getDeviceTypes().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object device = objectArray[n2];
            if (((IDeviceType)device).getId().equals(currentDeviceTypeId)) {
                this.currentDeviceType = (MobileDeviceType)device;
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        container.setFont(parent.getFont());
        Label label = new Label(container, 0);
        label.setText(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_name);
        label.setFont(container.getFont());
        this.nameText = new Text(container, 2048);
        GridData gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.setFont(container.getFont());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstanceManager manager = InstanceManager.getInstance();
                String name = DefaultDeviceTypeMenuWizardPage.this.nameText.getText();
                String errorMessage = null;
                if (name != null && !name.equals("")) {
                    if (manager.getInstancesByname(name).size() != 0) {
                        errorMessage = DeviceUIResources.TML_Emulator_Wizard_Project_Description_Duplicated_Error;
                    } else if (!AbstractMobileInstance.validName((String)name)) {
                        errorMessage = DeviceUIResources.TML_Instance_Name_Invalid_Error;
                    }
                }
                DefaultDeviceTypeMenuWizardPage.this.setErrorMessage(errorMessage);
                DefaultDeviceTypeMenuWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.createDeviceTypesArea(container);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.nameText.getText().trim() != "" && this.currentDeviceType != null;
    }

    private void createDeviceTypesArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(String.valueOf(DeviceUIResources.TML_Default_Device_Type_Wizard_Page_deviceTypes) + " " + this.currentDeviceType.getLabel());
        label.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewDeviceMenuWizard) {
            ((NewDeviceMenuWizard)wizard).setCurrentDeviceTypeId(this.currentDeviceType.getId());
        }
    }

    public String getInstanceName() {
        return this.nameText.getText().trim();
    }

    public MobileDeviceType getDeviceType() {
        return this.currentDeviceType;
    }
}

