/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.engine;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.eclipse.tml.common.utilities.BasePlugin;

public class NioDataInput
implements DataInput {
    private static final int IN_STREAM_TIMEOUT_MS = 3000;
    private static final int BUFFER_SIZE = 102400;
    private SocketChannel channel;
    private ByteBuffer buffer;

    NioDataInput(SocketChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(102400);
        this.buffer.flip();
    }

    byte[] close() throws IOException {
        byte[] remainingBytes = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.buffer != null) {
            int remaining = this.buffer.remaining();
            remainingBytes = new byte[remaining];
            this.buffer.get(remainingBytes);
        }
        return remainingBytes;
    }

    public boolean readBoolean() throws IOException {
        byte[] bytes = this.getBytesFromBuffer(1);
        return bytes[0] != 0;
    }

    public byte readByte() throws IOException {
        return this.readByte(true);
    }

    byte readByte(boolean timeoutEnabled) throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(1, timeoutEnabled));
        return (byte)bytes[0];
    }

    public char readChar() throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(2));
        return (char)((bytes[0] << 8) + (bytes[1] << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        byte[] bytes = this.getBytesFromBuffer(len - off);
        System.arraycopy(bytes, 0, b, off, len);
    }

    public int readInt() throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(4));
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + (bytes[3] << 0);
    }

    public String readLine() throws IOException {
        int offset;
        char[] buf;
        block8: {
            boolean readLine = false;
            buf = new char[128];
            int room = buf.length;
            offset = 0;
            try {
                block6: while (!readLine) {
                    int c = this.readUnsignedByte();
                    switch (c) {
                        case 10: {
                            readLine = true;
                            continue block6;
                        }
                        case 13: {
                            continue block6;
                        }
                    }
                    if (--room < 0) {
                        char[] previousBuffer = buf;
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(previousBuffer, 0, buf, 0, offset);
                    }
                    buf[offset++] = (char)c;
                }
            }
            catch (EOFException eOFException) {
                if (offset != 0) break block8;
                return null;
            }
        }
        return String.copyValueOf(buf, 0, offset);
    }

    public long readLong() throws IOException {
        byte[] bytes = this.getBytesFromBuffer(8);
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    public short readShort() throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(2));
        return (short)((bytes[0] << 8) + (bytes[1] << 0));
    }

    public String readUTF() throws IOException {
        return "";
    }

    public int readUnsignedByte() throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(1));
        return bytes[0];
    }

    public int readUnsignedShort() throws IOException {
        int[] bytes = this.asIntArray(this.getBytesFromBuffer(2));
        return (bytes[0] << 8) + (bytes[1] << 0);
    }

    public int skipBytes(int n) throws IOException {
        int bytesSkipped = 0;
        try {
            bytesSkipped = 0;
            while (bytesSkipped < n) {
                this.getBytesFromBuffer(1);
                ++bytesSkipped;
            }
        }
        catch (EOFException eOFException) {}
        return bytesSkipped;
    }

    private byte[] getBytesFromBuffer(int numOfBytes) throws IOException {
        return this.getBytesFromBuffer(numOfBytes, true);
    }

    private byte[] getBytesFromBuffer(int numOfBytes, boolean timeoutEnabled) throws IOException {
        byte[] bytes = new byte[numOfBytes];
        boolean allBytesRetrieved = false;
        int bytesGot = 0;
        int toBeGot = numOfBytes;
        while (!allBytesRetrieved) {
            int length = Math.min(toBeGot, this.buffer.remaining());
            this.buffer.get(bytes, bytesGot, length);
            toBeGot -= length;
            if ((bytesGot += length) >= numOfBytes) {
                allBytesRetrieved = true;
                continue;
            }
            this.fillBuffer(bytes.length - bytesGot, timeoutEnabled);
        }
        return bytes;
    }

    private void fillBuffer(int bytesToFill, boolean timeoutEnabled) throws IOException {
        this.buffer.clear();
        long lastCheckpoint = System.currentTimeMillis();
        int totalBytes = 0;
        while (this.buffer.remaining() > 0 && this.buffer.position() < bytesToFill) {
            int bytesRead = this.channel.read(this.buffer);
            if (bytesRead <= 0) {
                if (timeoutEnabled && System.currentTimeMillis() > lastCheckpoint + 3000L) {
                    BasePlugin.logError((String)"No data arrived through the input stream channel for 3000 milliseconds. Timeout expired.");
                    this.buffer.flip();
                    throw new EOFException("Timeout on communication detected!");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            lastCheckpoint = System.currentTimeMillis();
            totalBytes += bytesRead;
        }
        this.buffer.flip();
    }

    private int[] asIntArray(byte[] byteArray) {
        int[] intArray = new int[byteArray.length];
        int i = 0;
        while (i < byteArray.length) {
            intArray[i] = byteArray[i] & 0xFF;
            ++i;
        }
        return intArray;
    }
}

