/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IDeviceTypeRegistry;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.ui.DeviceUIPlugin;
import org.eclipse.tml.framework.status.IStatusTransition;

public class DeviceLabelProvider
extends LabelProvider {
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(11);

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof IDeviceTypeRegistry) {
            descriptor = ((IDeviceTypeRegistry)element).getImage();
        } else {
            if (element instanceof IDeviceType) {
                return ((IDeviceType)element).getImage();
            }
            if (element instanceof IService) {
                descriptor = ((IService)element).getImage();
            } else if (element instanceof IStatusTransition) {
                descriptor = DeviceUIPlugin.getDefault().getImageDescriptor("ICON_BOOK");
            } else {
                throw this.unknownElement(element);
            }
        }
        Image image = this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof IDeviceTypeRegistry) {
            return "Device Registry";
        }
        if (element instanceof IDeviceType) {
            if (((IDeviceType)element).getLabel() == null) {
                return "Device";
            }
            return String.valueOf(((IDeviceType)element).getLabel()) + "(" + ((IDeviceType)element).getId() + ")";
        }
        if (element instanceof IService) {
            return ((IService)element).getName();
        }
        if (element instanceof IStatusTransition) {
            return ((IStatusTransition)element).toString();
        }
        throw this.unknownElement(element);
    }

    public void dispose() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
    }

    protected RuntimeException unknownElement(Object element) {
        return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
    }
}

