/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.localization.stringeditor.editor.input.IStringEditorInput;
import org.eclipse.tml.localization.stringeditor.providers.ContentProvider;
import org.eclipse.tml.localization.stringeditor.providers.DefaultOperationProvider;
import org.eclipse.tml.localization.stringeditor.providers.ICellValidator;
import org.eclipse.tml.localization.stringeditor.providers.IOperationProvider;

public class EditorExtensionLoader {
    private static final String EXTENSION_POINT_ID = "contentprovider";
    private static final String PROVIDER_ELEMENT_ID = "provider";
    private static final String PROVIDER_EDITOR_CONTEXT_HELP_ID = "contextHelpID";
    private static final String PROVIDER_EDITOR_INPUT_ID = "editorInput";
    private static final String PROVIDER_OPERATION_PROV_ID = "operationsProvider";
    private static final String PROVIDER_CELL_VALIDATOR_ID = "cellValidator";
    private final Map<IFile, IConfigurationElement> knownProviders = new HashMap<IFile, IConfigurationElement>();
    private final List<IConfigurationElement> availableElements = new ArrayList<IConfigurationElement>();
    private static EditorExtensionLoader instance;

    private EditorExtensionLoader() {
        this.loadExtensions();
    }

    private void loadExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tml.localization.stringeditor", EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(PROVIDER_ELEMENT_ID)) {
                this.availableElements.add(element);
            }
            ++n2;
        }
    }

    public ContentProvider getContentProviderForFileInput(IFile file) {
        ContentProvider provider = null;
        IConfigurationElement iConfigurationElement = this.knownProviders.get(file);
        if (iConfigurationElement == null) {
            iConfigurationElement = this.searchElementForFile(file);
        }
        if (iConfigurationElement != null) {
            provider = EditorExtensionLoader.createContentProviderFromElement(iConfigurationElement);
        }
        return provider;
    }

    private IConfigurationElement searchElementForFile(IFile file) {
        IConfigurationElement elementResult = null;
        int i = 0;
        while (elementResult == null && i < this.availableElements.size()) {
            IConfigurationElement element = this.availableElements.get(i);
            ContentProvider prov = EditorExtensionLoader.createContentProviderFromElement(element);
            if (prov.getEditorInput().canHandle(file)) {
                elementResult = element;
                this.knownProviders.put(file, element);
                prov = null;
            }
            ++i;
        }
        return elementResult;
    }

    private static ContentProvider createContentProviderFromElement(IConfigurationElement element) {
        ContentProvider contentProvider = null;
        String contextHelpID = null;
        Object inputClazz = null;
        Object opClazz = null;
        Object cellValidator = null;
        try {
            inputClazz = element.createExecutableExtension(PROVIDER_EDITOR_INPUT_ID);
            opClazz = element.createExecutableExtension(PROVIDER_OPERATION_PROV_ID);
            cellValidator = element.createExecutableExtension(PROVIDER_CELL_VALIDATOR_ID);
            contextHelpID = element.getAttribute(PROVIDER_EDITOR_CONTEXT_HELP_ID);
        }
        catch (CoreException coreException) {
            BasePlugin.logWarning((String)("No operation provider found for " + element.getDeclaringExtension().getUniqueIdentifier() + ". Using a default operation provider."));
        }
        IStringEditorInput input = null;
        IOperationProvider provider = null;
        ICellValidator validator = null;
        if (inputClazz instanceof IStringEditorInput) {
            input = (IStringEditorInput)inputClazz;
        }
        provider = opClazz instanceof IOperationProvider ? (IOperationProvider)opClazz : new DefaultOperationProvider();
        if (cellValidator instanceof ICellValidator) {
            validator = (ICellValidator)cellValidator;
        }
        if (input != null) {
            contentProvider = new ContentProvider(input, provider, validator, contextHelpID.length() > 0 ? contextHelpID : null);
        }
        return contentProvider;
    }

    public static final EditorExtensionLoader getInstance() {
        if (instance == null) {
            instance = new EditorExtensionLoader();
        }
        return instance;
    }
}

