/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.datatype.IModelChangedListener;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.providers.ICellValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorViewerModel {
    private final List<ColumnInfo> columns;
    private final Map<String, ColumnInfo> columnsMap;
    private final Map<String, RowInfo> rowsMap;
    private final ICellValidator validator;
    private final List<IModelChangedListener> listeners;

    public StringEditorViewerModel(List<ColumnInfo> infos, ICellValidator cellValidator) {
        this.columns = infos;
        this.columnsMap = new HashMap<String, ColumnInfo>();
        this.rowsMap = new HashMap<String, RowInfo>();
        this.listeners = new ArrayList<IModelChangedListener>();
        this.validator = cellValidator;
        this.initMaps();
        this.doInitialValidation();
    }

    private void doInitialValidation() {
        for (RowInfo row : this.rowsMap.values()) {
            this.validateRow(row.getKey());
        }
    }

    private void initMaps() {
        for (ColumnInfo column : this.columns) {
            this.columnsMap.put(column.getId(), column);
            for (String cellKey : column.getCells().keySet()) {
                if (this.rowsMap.get(cellKey) == null) {
                    this.rowsMap.put(cellKey, new RowInfo(cellKey, null));
                }
                RowInfo rowInfo = this.rowsMap.get(cellKey);
                rowInfo.addCell(column.getId(), column.getCells().get(cellKey));
            }
        }
        this.notifyListeners();
    }

    public RowInfo getRow(String key) {
        return this.rowsMap.get(key);
    }

    public ColumnInfo getColumn(String ID) {
        return this.columnsMap.get(ID);
    }

    public Map<String, RowInfo> getRows() {
        return this.rowsMap;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public void addColumn(ColumnInfo info) {
        this.columns.add(info);
        this.columnsMap.put(info.getId(), info);
        Map<String, CellInfo> cells = info.getCells();
        for (String key : cells.keySet()) {
            RowInfo row = this.rowsMap.get(key);
            if (row == null) {
                row = new RowInfo(key, null);
                this.rowsMap.put(key, row);
            }
            row.addCell(info.getId(), info.getCells().get(key));
            this.validateRow(row);
        }
        this.notifyListeners();
    }

    public void addRow(RowInfo info) {
        Map<String, CellInfo> cells = info.getCells();
        this.rowsMap.put(info.getKey(), info);
        for (String column : cells.keySet()) {
            ColumnInfo columnInfo = this.columnsMap.get(column);
            if (columnInfo == null) {
                columnInfo = new ColumnInfo(column, column, null, true);
                this.columnsMap.put(column, columnInfo);
                this.columns.add(columnInfo);
            }
            columnInfo.addCell(info.getKey(), cells.get(column));
        }
        this.validateRow(info);
        this.notifyListeners();
    }

    public void addCell(CellInfo info, String key, String column) {
        this.columnsMap.get(column).addCell(key, info);
        this.rowsMap.get(key).addCell(column, info);
        this.validateRow(key);
        this.notifyListeners();
    }

    public void removeCell(String key, String column) {
        this.rowsMap.get(key).removeCell(column);
        this.columnsMap.get(column).removeCell(key);
        this.notifyListeners();
    }

    public void removeColumn(String column) {
        this.columnsMap.remove(column);
        ArrayList<ColumnInfo> orig = new ArrayList<ColumnInfo>(this.columns);
        for (ColumnInfo info : orig) {
            if (!info.getId().equals(column)) continue;
            this.columns.remove(info);
        }
        for (RowInfo row : this.rowsMap.values()) {
            row.removeCell(column);
        }
        this.notifyListeners();
    }

    public void removeRow(String key) {
        this.rowsMap.remove(key);
        for (ColumnInfo col : this.columnsMap.values()) {
            col.removeCell(key);
        }
        this.notifyListeners();
    }

    public void addListener(IModelChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModelChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IModelChangedListener listener : this.listeners) {
            listener.modelChanged(this);
        }
    }

    public List<RowInfo> save() {
        ArrayList<RowInfo> changed = new ArrayList<RowInfo>();
        for (RowInfo info : this.rowsMap.values()) {
            for (CellInfo cell : info.getCells().values()) {
                if (cell == null || !cell.isDirty()) continue;
                cell.setDirty(false);
                changed.add(info);
            }
        }
        return changed;
    }

    public List<ColumnInfo> getColumnsChanged() {
        HashSet<ColumnInfo> changed = new HashSet<ColumnInfo>();
        for (RowInfo info : this.rowsMap.values()) {
            for (Map.Entry<String, CellInfo> cellEntry : info.getCells().entrySet()) {
                CellInfo cell = cellEntry.getValue();
                if (cell == null || !cell.isDirty()) continue;
                changed.add(this.columnsMap.get(cellEntry.getKey()));
            }
        }
        return new ArrayList<ColumnInfo>(changed);
    }

    public void validateRow(String key) {
        RowInfo row = this.rowsMap.get(key);
        this.validateRow(row);
    }

    public void validateRow(RowInfo row) {
        row.cleanStatus();
        for (ColumnInfo column : this.columns) {
            CellInfo cell = row.getCells().get(column.getId());
            IStatus cellStatus = this.validator.isCellValid(column.getId(), row.getKey(), cell != null ? cell.getValue() : null);
            if (cellStatus.isOK()) continue;
            row.addStatus(cellStatus);
        }
    }

    public IStatus getStatus() {
        IStatus status = null;
        for (RowInfo row : this.rowsMap.values()) {
            if (row.getStatus().isOK()) continue;
            if (status == null) {
                status = new MultiStatus("org.eclipse.tml.localization.stringeditor", 0, null, null);
            }
            status.merge((IStatus)row.getStatus());
        }
        return status != null ? status : Status.OK_STATUS;
    }
}

