/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.stringeditor.editor.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.editor.StringEditorPart;
import org.eclipse.tml.localization.stringeditor.editor.operations.EditorOperation;

public class EditCellOperation
extends EditorOperation {
    private final String key;
    private final String column;
    private final CellInfo oldValue;
    private final CellInfo newValue;

    public EditCellOperation(String key, String column, CellInfo oldValue, CellInfo newValue, StringEditorPart editor) {
        super("Edit Cell", editor);
        this.key = key;
        this.column = column;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.redo(monitor, info);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getModel().addCell(this.newValue, this.key, this.column);
        if (this.newValue != null && !this.newValue.isDirty()) {
            this.newValue.setDirty(true);
        }
        try {
            if (this.newValue == null || this.newValue != null && this.newValue.getValue() == null) {
                this.getEditorInput().removeCell(this.key, this.column);
            } else {
                this.getEditorInput().setValue(this.column, this.key, this.newValue.getValue());
            }
        }
        catch (TmLException e) {
            BasePlugin.logError((String)("Error editing cell value: (" + this.column + ", " + this.key + ") = " + this.newValue != null ? this.newValue.getValue() : null), (Throwable)e);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.getModel().getRow(this.key), null);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getModel().addCell(this.oldValue, this.key, this.column);
        try {
            if (this.oldValue != null) {
                this.oldValue.setDirty(true);
            }
            if (this.oldValue != null && this.oldValue.getValue() != null) {
                this.getEditorInput().setValue(this.column, this.key, this.oldValue.getValue());
            } else {
                this.getEditorInput().removeCell(this.key, this.column);
            }
        }
        catch (TmLException e) {
            BasePlugin.logError((String)("Error undoing cell edition: (" + this.column + ", " + this.key + ") = " + this.oldValue != null ? this.oldValue.getValue() : null), (Throwable)e);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.getModel().getRow(this.key), null);
        return Status.OK_STATUS;
    }
}

