/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationFile;
import org.eclipse.tml.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.tml.localization.tools.extensions.providers.LocalizationSchemaProvider;
import org.eclipse.tml.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationManager {
    private Map<String, ILocalizationSchema> localizationSchemas;
    private List<String> natures;
    private Map<IProject, ProjectLocalizationManager> projectLocalizationManagers = new HashMap<IProject, ProjectLocalizationManager>();
    private LocalizationSchemaProvider localizationSchemaProvider;
    private static LocalizationManager instance = null;
    private Map<IProject, IFileChangeListener> fileChangeListeners = new HashMap<IProject, IFileChangeListener>();
    private final IResourceChangeListener resourceChangelistener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            LocalizationDeltaVisitor localizationDeltaVisitor = new LocalizationDeltaVisitor();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)localizationDeltaVisitor);
                }
            }
            catch (CoreException coreException) {
                BasePlugin.logError((String)"Could not handle changes in localization file");
            }
        }
    };

    public static LocalizationManager getInstance() {
        if (instance == null) {
            instance = new LocalizationManager();
        }
        return instance;
    }

    public LocalizationManager() {
        this.localizationSchemaProvider = LocalizationSchemaProvider.getInstance();
        this.localizationSchemas = this.localizationSchemaProvider.getLocalizationSchemas();
        this.natures = this.getNaturesInOrder();
    }

    public ProjectLocalizationManager getProjectLocalizationManager(IProject project, boolean force) {
        ProjectLocalizationManager projectManager = this.projectLocalizationManagers.get(project);
        if (projectManager == null) {
            ILocalizationSchema schema = this.getLocalizationSchema(project);
            if (schema != null) {
                projectManager = new ProjectLocalizationManager(project, schema);
                this.projectLocalizationManagers.put(project, projectManager);
            }
        } else if (force) {
            projectManager.reload();
        }
        return projectManager;
    }

    public void unloadProjectLocalizationManager(IProject project) {
        this.projectLocalizationManagers.remove(project);
    }

    public ILocalizationSchema getLocalizationSchema(IProject project) {
        ILocalizationSchema localizationSchemaForProject = null;
        try {
            for (String nature : this.natures) {
                if (!this.projectHasNature(project, nature)) continue;
                localizationSchemaForProject = this.localizationSchemas.get(nature);
            }
        }
        catch (CoreException coreException) {
            BasePlugin.logError((String)(String.valueOf(this.getClass().getName()) + ": Error getting Localization Schema"));
        }
        return localizationSchemaForProject;
    }

    private boolean projectHasNature(IProject project, String projectNature) throws CoreException {
        String[] natureIds;
        boolean projectHasNature = false;
        String[] stringArray = natureIds = project.getDescription().getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (natureId.equals(projectNature)) {
                projectHasNature = true;
                break;
            }
            ++n2;
        }
        return projectHasNature;
    }

    public ILocalizationSchema getLocalizationSchema(String nature) {
        return this.localizationSchemas.get(nature);
    }

    private void addWorkspaceListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.resourceChangelistener);
        workspace.addResourceChangeListener(this.resourceChangelistener, 5);
    }

    private void handleProjectDeletion(IProject pro) {
        ProjectLocalizationManager projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(pro.getProject(), false);
        if (projectLocalizationManager != null) {
            LocalizationManager.getInstance().unloadProjectLocalizationManager(pro);
        }
        this.notifyInputProjectRemoved(pro);
    }

    private void handleFileDeletion(IFile file) {
        ProjectLocalizationManager projectLocalizationManager = this.getProjectLocalizationManager(file.getProject(), false);
        if (projectLocalizationManager != null) {
            projectLocalizationManager.deleteFileMetaExtraData(file);
            LocalizationFile locFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(file);
            if (locFile != null) {
                projectLocalizationManager.getLocalizationProject().removeLocalizationFile(locFile);
                projectLocalizationManager.reload();
            }
        }
    }

    private void handleFileChange(IFile file, IResourceDelta delta) {
        LocalizationFile locFile;
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.tml.localization.tools.extensions.implementation.android.localizationEditor");
        ProjectLocalizationManager projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(file.getProject(), false);
        if (projectLocalizationManager != null && (locFile = projectLocalizationManager.getLocalizationProject().getLocalizationFile(file)) != null && !locFile.isToBeDeleted() && this.hasFileChanged(file, locFile, projectLocalizationManager)) {
            this.notifyInputChange(file);
        }
    }

    private boolean hasFileChanged(IFile file, LocalizationFile locFile, ProjectLocalizationManager projectLocalizationManager) {
        boolean result = false;
        try {
            LocalizationFile newLocalizationFile = projectLocalizationManager.getProjectLocalizationSchema().loadFile(file);
            if (!locFile.equals(newLocalizationFile)) {
                result = true;
            }
        }
        catch (IOException iOException) {
            BasePlugin.logError((String)"Could not compare localization file versions");
        }
        return result;
    }

    private void handleFileAddition(IFile file) {
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.tml.localization.tools.extensions.implementation.android.localizationEditor");
    }

    private List<String> getNaturesInOrder() {
        ArrayList<String> natures = new ArrayList<String>();
        for (ILocalizationSchema schema : this.localizationSchemas.values()) {
            natures.add(schema.getNatureName());
        }
        return natures;
    }

    public void initialize() {
        List<IProject> supportedProjects = this.getSupportedProjects();
        for (IProject project : supportedProjects) {
            ILocalizationSchema localizationSchema = this.getLocalizationSchema(project);
            Map<LocaleInfo, IFile> files = localizationSchema.getLocalizationFiles(project);
            for (IFile file : files.values()) {
                this.handleFileAddition(file);
            }
        }
        this.addWorkspaceListener();
    }

    public List<IProject> getSupportedProjects() {
        IProject[] projects;
        ArrayList<IProject> supportedProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.getLocalizationSchema(project) != null) {
                supportedProjects.add(project);
            }
            ++n2;
        }
        return supportedProjects;
    }

    public void addFileChangeListener(IFileChangeListener fileChangeListener) {
        this.fileChangeListeners.put(fileChangeListener.getProject(), fileChangeListener);
    }

    public void removeFileChangeListener(IFileChangeListener fileChangeListener) {
        this.fileChangeListeners.remove(fileChangeListener.getProject());
    }

    public void notifyInputChange(IFile file) {
        IFileChangeListener fileChangeListener = this.fileChangeListeners.get(file.getProject());
        if (fileChangeListener != null) {
            fileChangeListener.fileChanged(file);
        }
    }

    public void notifyInputProjectRemoved(IProject project) {
        IFileChangeListener fileChangeListener = this.fileChangeListeners.get(project);
        if (fileChangeListener != null) {
            fileChangeListener.projectRemoved();
        }
    }

    public static interface IFileChangeListener {
        public void fileChanged(IFile var1);

        public IProject getProject();

        public void projectRemoved();
    }

    class LocalizationDeltaVisitor
    implements IResourceDeltaVisitor {
        LocalizationDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource != null) {
                ILocalizationSchema localizationSchema;
                IProject project;
                if (resource instanceof IProject) {
                    IProject affectedProject = (IProject)resource;
                    if (delta.getKind() == 2) {
                        LocalizationManager.this.handleProjectDeletion(affectedProject);
                    }
                }
                if ((project = resource.getProject()) != null && (localizationSchema = LocalizationManager.this.getLocalizationSchema(project)) != null && resource instanceof IFile && localizationSchema.isLocalizationFile((IFile)resource)) {
                    if (delta.getKind() == 1) {
                        LocalizationManager.this.handleFileAddition((IFile)resource);
                    } else if (delta.getKind() == 4) {
                        LocalizationManager.this.handleFileChange((IFile)resource, delta);
                    } else if (delta.getKind() == 2) {
                        LocalizationManager.this.handleFileDeletion((IFile)resource);
                    }
                }
            }
            return true;
        }
    }
}

