/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.memorymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.memorymap.Messages;

public class MemoryMapProcessor
extends AbstractNotifier
implements IListener {
    private final String CMD_FETCH_IOMEM = "/proc/iomem";
    private final String PARSE_PATTERN = "\\s*(\\w{8})-(\\w{8})\\s*:\\s*(.*)";
    private final String MSG_EXECUTING_COMMAND = Messages.MemoryMapProcessor_Msg_Executing_The_Command;
    private final String MSG_GOT_RESULT = Messages.MemoryMapProcessor_Msg_Got_The_Result;
    private final int MAX_COLUMNS = 4;
    private IConnectionProvider connectionProvider = null;
    private ILogger logger = null;

    public MemoryMapProcessor(IConnectionProvider connectionProvider) {
        this.setConnectionProvider(connectionProvider);
        this.logger = LinuxToolsPlugin.getLogger();
    }

    public void gatherData() throws IOException {
        this.connectionProvider.setResponseLength(8192);
        this.connectionProvider.sendCommand(IConstants.CommandCode.FETCH_FILE, "/proc/iomem");
        this.logger.debug((Object)(String.valueOf(this.MSG_EXECUTING_COMMAND) + "\n" + "/proc/iomem"));
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        if (notifier == this.connectionProvider && event == IConstants.EventCode.EVT_PROVIDER_SENDCOMMAND_FINISHED) {
            this.connectionProvider.setResponseLength(1024);
            Object[][] parsedResult = this.parseIomem((StringBuffer)result);
            this.notifyListeners(IConstants.EventCode.EVT_PROCESSOR_GATHERDATA_FINISHED, parsedResult);
        }
    }

    public void setConnectionProvider(IConnectionProvider connectionProvider) {
        if (this.connectionProvider != null) {
            this.connectionProvider.removeListener((IListener)this);
        }
        this.connectionProvider = connectionProvider;
        if (this.connectionProvider != null) {
            this.connectionProvider.addListener((IListener)this);
        }
    }

    private Object[][] parseIomem(StringBuffer data) {
        this.logger.debug((Object)(String.valueOf(this.MSG_GOT_RESULT) + "\n" + data.toString()));
        Scanner s1 = new Scanner(data.toString());
        ArrayList<String[]> list = new ArrayList<String[]>();
        int j = 0;
        while (s1.hasNextLine()) {
            Scanner s2 = new Scanner(s1.nextLine());
            s2.findInLine("\\s*(\\w{8})-(\\w{8})\\s*:\\s*(.*)");
            String[] entry = null;
            try {
                MatchResult result = s2.match();
                entry = new String[4];
                int i = 1;
                while (i <= result.groupCount() && i <= 3) {
                    entry[i - 1] = result.group(i);
                    ++i;
                }
                entry[3] = new Integer(j).toString();
                ++j;
            }
            catch (IllegalStateException illegalStateException) {}
            s2.close();
            if (entry == null) continue;
            list.add(entry);
        }
        s1.close();
        Object[][] retVal = new String[list.size()][4];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = (String[])list.get(i);
            ++i;
        }
        return retVal;
    }
}

