/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.manager.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tml.common.utilities.exception.ExceptionHandler;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.DevicePlugin;
import org.eclipse.tml.framework.device.exception.DeviceExceptionHandler;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.manager.persistence.IDeviceXmlTags;
import org.eclipse.tml.framework.device.model.IInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceXmlReader
implements IDeviceXmlTags {
    public static Collection<IInstance> loadInstances() {
        File path = DevicePlugin.getDeviceXmlLocation();
        File file = new File(path, "tml_devices.xml");
        ArrayList<IInstance> loadedInstances = new ArrayList<IInstance>();
        if (file.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Element rootElement = document.getDocumentElement();
                loadedInstances.addAll(DeviceXmlReader.parseInstancesList(rootElement));
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return loadedInstances;
    }

    private static Collection<IInstance> parseInstancesList(Element rootElement) {
        Node node;
        LinkedHashSet<IInstance> loadedInstances = new LinkedHashSet<IInstance>();
        NodeList instancesNodes = rootElement.getElementsByTagName("instances");
        if (instancesNodes != null && instancesNodes.getLength() == 1 && (node = instancesNodes.item(0)).getNodeType() == 1) {
            Element instancesElement = (Element)node;
            NodeList instanceNodeList = instancesElement.getElementsByTagName("instance");
            int i = 0;
            while (instanceNodeList != null && i < instanceNodeList.getLength()) {
                Node childNode = instanceNodeList.item(i);
                if (childNode.getNodeType() == 1) {
                    Element childElement = (Element)childNode;
                    String xml_device_id = childElement.getAttribute("deviceType_id");
                    String instanceName = childElement.getAttribute("name");
                    Properties prop = new Properties();
                    NodeList propList = childElement.getChildNodes();
                    int j = 0;
                    while (propList != null && j < propList.getLength()) {
                        Node propNode = propList.item(j);
                        if (propNode.getNodeType() == 1) {
                            Element propElement = (Element)propNode;
                            prop.put(propElement.getTagName(), propElement.getTextContent());
                        }
                        ++j;
                    }
                    IInstance inst = null;
                    if (instanceName != null && !instanceName.equals("") && xml_device_id != null && !xml_device_id.equals("")) {
                        try {
                            inst = InstanceManager.createInstance(instanceName, xml_device_id, "OFF", prop);
                            loadedInstances.add(inst);
                        }
                        catch (TmLException tmLException) {
                            ExceptionHandler.showException((TmLException)DeviceExceptionHandler.exception(202));
                        }
                    }
                }
                ++i;
            }
        }
        return loadedInstances;
    }
}

