/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.internal.model.ClientModel;
import org.eclipse.tml.protocol.lib.internal.model.ServerModel;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolActionDelegate {
    public static ProtocolHandle requestStartProtocolAsClient(Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolHandshake protocolInitializer, IProtocolExceptionHandler exceptionHandler, Boolean isBigEndianProtocol, String host, int port, Map<String, Object> parameters) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to start a client protocol. host=" + host + "; port=" + port + "."));
        ClientModel model = ClientModel.getInstance();
        return model.requestStartProtocol(allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol, host, port, parameters);
    }

    public static ProtocolHandle requestStartProtocolAsServer(int portToBind, Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolHandshake protocolInitializer, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to start a server protocol at port " + portToBind + "."));
        ServerModel model = ServerModel.getInstance();
        return model.startListeningToPort(portToBind, allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol);
    }

    public static void requestStopProtocol(ProtocolHandle handle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("A user is requesting to stop the protocol identified by " + handle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestStopProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.stopListeningToPort(handle);
    }

    public static void requestRestartProtocol(ProtocolHandle handle) {
        BasePlugin.logDebugMessage((String)"ProtocolActionDelegate", (String)("An user is requesting to restart the protocol identified by " + handle));
        ClientModel clientModel = ClientModel.getInstance();
        clientModel.requestRestartProtocol(handle);
        ServerModel serverModel = ServerModel.getInstance();
        serverModel.requestRestartProtocol(handle);
    }

    public static void sendMessageToServer(ProtocolHandle handle, ProtocolMessage message) {
        ClientModel model = ClientModel.getInstance();
        model.sendMessage(handle, message);
    }

    public static boolean isProtocolRunning(ProtocolHandle handle) {
        return ClientModel.getInstance().isClientProtocolRunning(handle) || ServerModel.getInstance().isListeningToPort(handle);
    }
}

