/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableContent;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RowGroupExtensions {
    public static TableRow addRow(RowGroup group, List<TableCell> cells) {
        TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
        group.getRows().add((Object)newRow);
        Table table = RowGroupExtensions.getTable(group);
        Consumer<ColumnDescriptor> _function = it -> newRow.getCells().add((Object)ColumnDescriptorExtensions.createTableCell(it));
        TableExtensions.getColumns(table).forEach(_function);
        Consumer<TableCell> _function_1 = cell -> {
            CellContent content = cell.getContent();
            String columnPosition = cell.getColumndescriptor().getColumnPosition();
            Functions.Function1 _function_2 = it -> {
                String _columnPosition = it.getColumndescriptor().getColumnPosition();
                return Objects.equals(_columnPosition, columnPosition);
            };
            TableCell targetCell = (TableCell)IterableExtensions.findFirst((Iterable)newRow.getCells(), (Functions.Function1)_function_2);
            if (targetCell != null) {
                boolean _not;
                targetCell.setContent(content);
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)cell.getCellannotation());
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    TableCellExtensions.setTextAlignment(targetCell, TableCellExtensions.getFormat(cell).getTextAlignment());
                }
            }
        };
        cells.forEach(_function_1);
        return newRow;
    }

    public static Table getTable(RowGroup group) {
        return TableContentExtensions.getTable(RowGroupExtensions.getContent(group));
    }

    public static TableContent getContent(RowGroup group) {
        EObject _eContainer = group.eContainer();
        return (TableContent)_eContainer;
    }

    public static boolean isEqual(RowGroup group, RowGroup other) {
        int _size_1;
        boolean _notEquals;
        int _size = group.getRows().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getRows().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1 _function = it -> TableRowExtensions.isEqual((TableRow)it.getValue(), (TableRow)other.getRows().get(((Integer)it.getKey()).intValue()));
        return IterableExtensions.forall((Iterable)IterableExtensions.indexed((Iterable)group.getRows()), (Functions.Function1)_function);
    }

    public static List<TableCell> getColumnCells(RowGroup group, ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> TableRowExtensions.getCell(it, descriptor);
        return ListExtensions.map((List)group.getRows(), (Functions.Function1)_function);
    }

    public static void setTextAlignment(RowGroup group, int columnIdx, TextAlignment textAlignment) {
        Consumer<TableRow> _function = it -> {
            TableCell _get = (TableCell)it.getCells().get(columnIdx);
            TableCellExtensions.setTextAlignment(_get, textAlignment);
        };
        group.getRows().forEach(_function);
    }

    public static RowGroup findRowGroup(Table table, TableRow row, List<ColumnDescriptor> excludeCols) {
        EList groups = table.getTablecontent().getRowgroups();
        Functions.Function1 _function = it -> {
            boolean _contains = excludeCols.contains(it);
            return !_contains;
        };
        Iterable sameValueCols = IterableExtensions.filter(TableExtensions.getColumns(table), (Functions.Function1)_function);
        Functions.Function1 _function_1 = group -> {
            boolean _xblockexpression = false;
            TableRow firstRowInGroup = (TableRow)group.getRows().get(0);
            Functions.Function1 _function_2 = it -> IterableExtensions.contains((Iterable)sameValueCols, (Object)it.getColumndescriptor());
            Functions.Function1 _function_3 = it -> {
                String groupValue = CellContentExtensions.getPlainStringValue(it.getContent());
                String rowValue = TableRowExtensions.getPlainStringValue(row, it.getColumndescriptor());
                return groupValue.equals(rowValue);
            };
            _xblockexpression = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)firstRowInGroup.getCells(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
            return _xblockexpression;
        };
        return (RowGroup)IterableExtensions.findFirst((Iterable)groups, (Functions.Function1)_function_1);
    }
}

