/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.track;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.ToolboxConfiguration;

public class MetaDataCache {
    static final String METADATA_CACHE_ID = "toolbox.cache.overviewplan.trackservice.metadata";
    static final Map<String, TOPKanteMetaData> topCache = new HashMap<String, TOPKanteMetaData>();

    private MetaDataCache() {
    }

    public static List<TOPKanteMetaData> getAllMetaData(MultiContainer_AttributeGroup container) {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            Cache cache = Services.getCacheService().getCache(MetaDataCache.getCacheString(container));
            List<TOPKanteMetaData> metadatas = cache.getKeys().stream().map(key -> (TOPKanteMetaData)cache.getIfPresent(key)).filter(Objects::nonNull).toList();
            return metadatas;
        }
        return new ArrayList<TOPKanteMetaData>(topCache.values());
    }

    public static TOPKanteMetaData getMetaData(TOP_Kante edge) {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)edge);
            Cache cache = Services.getCacheService().getCache(MetaDataCache.getCacheString(container));
            return (TOPKanteMetaData)cache.getIfPresent(edge.getIdentitaet().getWert());
        }
        return topCache.getOrDefault(edge.getIdentitaet().getWert(), null);
    }

    public static void setMetaData(TOP_Kante edge, TOPKanteMetaData edgeMetadata) {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer((EObject)edge);
            Cache cache = Services.getCacheService().getCache(MetaDataCache.getCacheString(container));
            cache.set(edge.getIdentitaet().getWert(), (Object)edgeMetadata);
            return;
        }
        topCache.put(edge.getIdentitaet().getWert(), edgeMetadata);
    }

    public static void clearCache(MultiContainer_AttributeGroup container) {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            Cache cache = Services.getCacheService().getCache(MetaDataCache.getCacheString(container));
            cache.invalidate();
            return;
        }
        topCache.clear();
    }

    private static String getCacheString(MultiContainer_AttributeGroup container) {
        return "toolbox.cache.overviewplan.trackservice.metadata/" + container.getCacheString();
    }
}

