/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.osgi.service.component.annotations.Component;

@Component
public class UniqueTopKanteBereichObject
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Mehrfache Teilbereiche";
    }

    @Override
    public String getDescription() {
        return "Alle Bereichsobjekte haben eindeutige TOP-Kanten definiert.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "F\u00fcr das Bereichsobjekt {Objektart} sind mehrere Teilbereiche auf der TOP-Kante {GUID} definiert.";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        ArrayList<PlazError> result = new ArrayList<PlazError>();
        Streams.stream((Iterable)container.getBereichObjekt()).forEach(bo -> {
            List<TOP_Kante> topKanten = bo.getBereichObjektTeilbereich().stream().map(botb -> botb.getIDTOPKante().getValue()).toList();
            Set<TOP_Kante> duplicateTopKanten = topKanten.parallelStream().filter(tk -> Collections.frequency(topKanten, tk) > 1).collect(Collectors.toSet());
            if (duplicateTopKanten.isEmpty()) {
                return;
            }
            duplicateTopKanten.forEach(topKante -> bo.getBereichObjektTeilbereich().stream().filter(botb -> botb.getIDTOPKante().getValue() == topKante).forEach(botb -> {
                boolean bl = result.add(this.createError((Bereich_Objekt)bo, (Bereich_Objekt_Teilbereich_AttributeGroup)botb, (TOP_Kante)topKante));
            }));
        });
        return result;
    }

    private PlazError createError(Bereich_Objekt bo, Bereich_Objekt_Teilbereich_AttributeGroup botb, TOP_Kante topKante) {
        PlazError error = PlazFactory.eINSTANCE.createPlazError();
        error.setSeverity(ValidationSeverity.WARNING);
        error.setObject((EObject)botb);
        error.setType(this.checkType());
        error.setMessage(this.transformErrorMsg(Map.of("Objektart", bo.eClass().getName(), "GUID", topKante.getIdentitaet().getWert())));
        return error;
    }
}

