/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.export;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.set.basis.export.CheckboxModelElement;

public class CheckBoxTreeElement
extends CheckboxModelElement {
    CheckBoxTreeElement parent;
    List<CheckBoxTreeElement> childs = new ArrayList<CheckBoxTreeElement>();

    public CheckBoxTreeElement(String id, String name) {
        this(id, name, null);
    }

    public CheckBoxTreeElement(String id, String name, String status) {
        super(id, name, status);
    }

    public CheckBoxTreeElement getParent() {
        return this.parent;
    }

    public boolean isParent() {
        return !this.childs.isEmpty();
    }

    public List<CheckBoxTreeElement> getChildElements() {
        return this.childs;
    }

    public void addChild(CheckBoxTreeElement child) {
        child.parent = this;
        this.childs.add(child);
    }

    @Override
    public void select() {
        this.selected = true;
        if (this.isParent()) {
            this.childs.forEach(ele -> ele.select());
        }
        this.selectParent();
    }

    private void selectParent() {
        CheckBoxTreeElement element = this.parent;
        while (element != null && element.isAllChildSameState(true)) {
            element.selected = true;
            element = element.parent;
        }
    }

    @Override
    public void deselect() {
        this.selected = false;
        if (this.isParent()) {
            this.childs.forEach(ele -> ele.deselect());
        }
        this.deselectParent();
    }

    private void deselectParent() {
        CheckBoxTreeElement element = this.parent;
        while (element != null && element.selected) {
            element.selected = false;
            element = element.parent;
        }
    }

    @Override
    public boolean isChecked() {
        if (this.childs.isEmpty()) {
            return super.isChecked();
        }
        return this.childs.stream().allMatch(ele -> ele.isChecked());
    }

    private boolean isAllChildSameState(boolean checked) {
        if (!this.isParent()) {
            return false;
        }
        return this.childs.stream().allMatch(ele -> ele.isChecked() == checked);
    }
}

