/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.set.utils.export.xsl.AbstractTransformTableHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDocumentExtensions {
    public static Element createXMLElementWithAttrName(Document doc, String tag, String name) {
        Element element = doc.createElement(tag);
        element.setAttribute("name", name);
        return element;
    }

    public static Element createXMLElementWithAttr(Document doc, String tag, XMLAttribute ... attributes) {
        Element element = doc.createElement(tag);
        Arrays.stream(attributes).forEach(attribute -> element.setAttribute(attribute.name, attribute.value));
        return element;
    }

    public static void setXSLElementValue(Document doc, String tagName, String elementName, double value) throws NullPointerException {
        String stringValue = String.valueOf(value) + "mm";
        XMLDocumentExtensions.setXSLElementValue(doc, tagName, elementName, stringValue);
    }

    public static void setXSLElementValue(Document doc, String tagName, String elementName, String value) throws NullPointerException {
        Optional<Element> element = AbstractTransformTableHeader.findNodebyTagName(doc, tagName, "name", elementName);
        if (element.isEmpty()) {
            throw new NullPointerException(String.format("Can't find element with tag: %s and name attribute: %s", tagName, elementName));
        }
        element.get().setTextContent(value);
    }

    public record XMLAttribute(String name, String value) {
        public XMLAttribute(String name, double doubleValue) {
            this(name, String.valueOf(doubleValue) + "mm");
        }
    }
}

