/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.tabletype;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.set.application.Messages;
import org.eclipse.set.application.toolcontrol.ServiceProvider;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableTypeSelectionControl {
    static final Logger LOGGER = LoggerFactory.getLogger(TableTypeSelectionControl.class);
    private final MApplication application;
    private final IEventBroker broker;
    private final EnumTranslationService enumTranslationService;
    @Translation
    private final Messages messages;
    private IModelSession oldSession;
    ToolboxPartService partService;
    private ComboViewer comboViewer;
    private TableType oldSelectedValue;

    public TableTypeSelectionControl(Composite parent, ServiceProvider serviceProvider) {
        this.application = serviceProvider.application;
        this.broker = serviceProvider.broker;
        this.enumTranslationService = serviceProvider.enumTranslationService;
        this.messages = serviceProvider.messages;
        this.partService = serviceProvider.partService;
        this.createTableCombo(parent);
        this.oldSelectedValue = TableType.DIFF;
    }

    private void createTableCombo(Composite parent) {
        this.comboViewer = new ComboViewer(parent);
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new TableTypeLabelProvider(this.enumTranslationService));
        this.initCombo();
        this.comboViewer.addSelectionChangedListener(event -> {
            ISelection iSelection = event.getSelection();
            if (iSelection instanceof IStructuredSelection) {
                void selection;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
                Object object = selection.getFirstElement();
                if (object instanceof TableType) {
                    void selectedType;
                    TableType tableType = (TableType)object;
                    TableType cfr_ignored_1 = (TableType)object;
                    if (!this.oldSelectedValue.equals((Object)selectedType)) {
                        this.oldSelectedValue = selectedType;
                        ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new NewTableTypeEvent((TableType)selectedType));
                    }
                }
            }
        });
        this.setCombo(this.getSession());
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                TableTypeSelectionControl.this.setCombo((IModelSession)context.get(IModelSession.class));
                ToolboxEvents.send((IEventBroker)TableTypeSelectionControl.this.broker, (ToolboxEvent)new NewTableTypeEvent(TableTypeSelectionControl.this.oldSelectedValue));
                return true;
            }
        });
    }

    private static boolean isPlanning(IModelSession session) {
        return PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)session.getPlanProSchnittstelle());
    }

    private String getMaxLengthItem() {
        LinkedList<String> items = new LinkedList<String>();
        items.add(this.messages.TableTypeSelectionControl_noSession);
        items.add(this.enumTranslationService.translate((Translateable)TableType.INITIAL).getPresentation());
        items.add(this.enumTranslationService.translate((Translateable)TableType.FINAL).getPresentation());
        items.add(this.enumTranslationService.translate((Translateable)TableType.SINGLE).getPresentation());
        Collections.sort(items, (o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o2.length() > o1.length()) {
                return 1;
            }
            return 0;
        });
        return (String)items.getFirst();
    }

    private IModelSession getSession() {
        return (IModelSession)this.application.getContext().get(IModelSession.class);
    }

    private void initCombo() {
        this.clearCombo();
        this.comboViewer.add((Object)this.messages.TableTypeSelectionControl_noSession);
        this.comboViewer.add((Object)this.getMaxLengthItem());
        this.comboViewer.getCombo().select(0);
        this.comboViewer.getCombo().setEnabled(false);
    }

    private void setCombo(IModelSession session) {
        if (session == this.oldSession) {
            return;
        }
        this.oldSession = session;
        if (session == null) {
            this.initCombo();
        } else {
            this.clearCombo();
            if (TableTypeSelectionControl.isPlanning(session)) {
                this.comboViewer.setInput((Object)new Object[]{TableType.DIFF, TableType.INITIAL, TableType.FINAL});
                this.comboViewer.getCombo().select(0);
                this.comboViewer.getCombo().setEnabled(true);
            } else {
                this.comboViewer.add((Object)TableType.SINGLE);
                this.comboViewer.getCombo().select(0);
                this.comboViewer.getCombo().setEnabled(false);
                this.oldSelectedValue = TableType.SINGLE;
            }
        }
    }

    private void clearCombo() {
        this.comboViewer.getCombo().removeAll();
        this.comboViewer.getCombo().clearSelection();
        this.oldSelectedValue = TableType.DIFF;
    }

    private static class TableTypeLabelProvider
    extends LabelProvider {
        EnumTranslationService translationService;

        public TableTypeLabelProvider(EnumTranslationService translationService) {
            this.translationService = translationService;
        }

        /*
         * WARNING - void declaration
         */
        public String getText(Object element) {
            Object object = element;
            if (object instanceof TableType) {
                void type;
                TableType tableType = (TableType)object;
                TableType cfr_ignored_0 = (TableType)object;
                return this.translationService.translate((Translateable)type).getPresentation();
            }
            return super.getText(element);
        }
    }
}

