/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EObjectExtensions {
    private static Logger logger = LoggerFactory.getLogger(EObjectExtensions.class);

    public static void fillDefaults(EObject object) {
        Functions.Function1 _function = it -> it.getLowerBound() == 1 && it.getUpperBound() == 1;
        Functions.Function1 _function_1 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        Consumer<EReference> _function_2 = it -> {
            try {
                EObject value = EcoreUtil.create((EClass)it.getEReferenceType());
                EObjectExtensions.fillDefaults(value);
                object.eSet((EStructuralFeature)it, (Object)value);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    logger.error(e.getMessage());
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        Functions.Function1 _function_3 = it -> it.isUnsettable();
        Functions.Function1 _function_4 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        Consumer<EAttribute> _function_5 = it -> object.eSet((EStructuralFeature)it, null);
        IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_3), (Functions.Function1)_function_4).forEach(_function_5);
        Consumer<EObject> _function_6 = it -> EObjectExtensions.fillDefaults(it);
        object.eContents().forEach(_function_6);
    }

    public static boolean containsUnfilledValues(EObject object) {
        boolean _not_1;
        boolean _not;
        Functions.Function1 _function = it -> it.getLowerBound() == 1 && it.getUpperBound() == 1;
        Functions.Function1 _function_1 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return true;
        }
        Functions.Function1 _function_2 = it -> it.isUnsettable();
        Functions.Function1 _function_3 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            return true;
        }
        Functions.Function1 _function_4 = it -> EObjectExtensions.containsUnfilledValues(it);
        Functions.Function2 _function_5 = (a, b) -> a != false || b != false;
        return (Boolean)IterableExtensions.fold((Iterable)ListExtensions.map((List)object.eContents(), (Functions.Function1)_function_4), (Object)false, (Functions.Function2)_function_5);
    }

    public static Iterable<Pair<EStructuralFeature, EObject>> getUnfilledValues(EObject object) {
        Functions.Function1 _function = it -> it.getLowerBound() == 1 && !it.isMany();
        Functions.Function1 _function_1 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        Iterable unsetReferences = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> it.isUnsettable();
        Functions.Function1 _function_3 = it -> {
            boolean _eIsSet = object.eIsSet((EStructuralFeature)it);
            return !_eIsSet;
        };
        Iterable unsetAttributes = IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)object.eClass().getEAttributes(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        Functions.Function1 _function_4 = it -> Pair.of((Object)it, (Object)object);
        Iterable _map = IterableExtensions.map((Iterable)Iterables.concat((Iterable)unsetReferences, (Iterable)unsetAttributes), (Functions.Function1)_function_4);
        Functions.Function1 _function_5 = it -> EObjectExtensions.getUnfilledValues(it);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)object.eContents(), (Functions.Function1)_function_5);
        return Iterables.concat((Iterable)_map, (Iterable)_flatMap);
    }

    public static String toCSV(EObject object) {
        Functions.Function1 _function = it -> {
            Object attr = object.eGet((EStructuralFeature)it);
            if (attr == null) {
                return "";
            }
            if (attr instanceof String) {
                return ((String)attr).replace("\"", "\"\"");
            }
            return attr.toString();
        };
        String _join = String.join((CharSequence)";", ListExtensions.map((List)object.eClass().getEAttributes(), (Functions.Function1)_function));
        String _lineSeparator = System.lineSeparator();
        return _join + _lineSeparator;
    }

    public static <T, U> Optional<U> getNullableObject(T t, Functions.Function1<? super T, ? extends U> func) {
        try {
            return Optional.ofNullable(func.apply(t));
        }
        catch (Throwable _t) {
            if (_t instanceof NullPointerException) {
                NullPointerException e = (NullPointerException)_t;
                logger.debug(e.getMessage());
                return Optional.empty();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static <T> Optional<T> getIndexOutBoundableObject(List<T> t, int index) {
        try {
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(t);
            if (_isNullOrEmpty) {
                return Optional.empty();
            }
            return Optional.ofNullable(t.get(index));
        }
        catch (Throwable _t) {
            if (_t instanceof IndexOutOfBoundsException) {
                IndexOutOfBoundsException e = (IndexOutOfBoundsException)_t;
                logger.debug(e.getMessage());
                return Optional.empty();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

