/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.enumtransformation.parts;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.basis.files.ToolboxFileFilterBuilder;
import org.eclipse.set.core.services.enumtranslation.EnumTranslation;
import org.eclipse.set.feature.enumtransformation.Messages;
import org.eclipse.set.feature.enumtransformation.impl.EnumTransformation;
import org.eclipse.set.feature.enumtransformation.impl.TranslationCode;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.widgets.FileField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumImportPart
extends BasePart {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumImportPart.class);
    private static final String XLS = "xls";
    private FileField fileField;
    @Inject
    @Translation
    private Messages messages;
    private Text textField;

    private static Path getMessagesFile(TranslationCode code, Path path) {
        return Paths.get(path.getParent().toString(), code.getMessageFile());
    }

    private static Path getPropertiesFile(TranslationCode code, Path path) {
        return Paths.get(path.getParent().toString(), code.getPropertiesFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeToFile(String content, Path path, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());
            try {
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);){
                    outputStreamWriter.write(content);
                }
                if (fileOutputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void addLine(String text) {
        this.textField.setText(this.textField.getText() + text + String.format("%n", new Object[0]));
    }

    private List<ToolboxFileFilter> createFileFilter() {
        ToolboxFileFilter xls = ToolboxFileFilterBuilder.forName((String)this.messages.EnumImportPart_FileFilterName).add(new String[]{XLS}).filterNameWithFilterList(true).create();
        return Lists.newArrayList((Object[])new ToolboxFileFilter[]{xls});
    }

    private void pathSelected(Path path) {
        this.addLine(String.format(this.messages.EnumImportPart_StartImportPattern, path.toString()));
        try {
            Map<String, EnumTranslation> translations = EnumTransformation.transform(path);
            TranslationCode code = EnumTransformation.transform(translations);
            EnumImportPart.writeToFile(code.getMessages(), EnumImportPart.getMessagesFile(code, path), StandardCharsets.UTF_8);
            EnumImportPart.writeToFile(code.getProperties(), EnumImportPart.getPropertiesFile(code, path), StandardCharsets.UTF_8);
            this.addLine(this.messages.EnumImportPart_FinishImport);
        }
        catch (Exception e) {
            this.addLine(e.getMessage());
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            this.addLine(stringWriter.toString());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void createView(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.fileField = new FileField(parent, this.createFileFilter(), this.getDialogService());
        this.fileField.getButton().setText(this.messages.EnumImportPart_ImportButtonText);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fileField.getComposite());
        this.fileField.addPathListener(this::pathSelected);
        this.textField = new Text(parent, 2634);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.textField);
        this.addLine(this.messages.EnumImportPart_Advice);
    }
}

