/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.widgets;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FolderField {
    private Function<Path, Boolean> pathValidation = null;
    protected final Button button;
    protected final Composite composite;
    protected final DialogService dialogService;
    protected Path path;
    protected final Text text;

    public FolderField(final Composite parent, DialogService dialogService) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.dialogService = dialogService;
        this.text = new Text(this.composite, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.button = new Button(this.composite, 0);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FolderField.this.selectFolder(parent.getShell());
            }

            public void widgetSelected(SelectionEvent e) {
                FolderField.this.selectFolder(parent.getShell());
            }
        });
    }

    public Button getButton() {
        return this.button;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Text getText() {
        return this.text;
    }

    public boolean isEnabled() {
        return this.button.getEnabled() || this.text.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.button.setEnabled(value);
        this.text.setEnabled(value);
    }

    public void setPathValidation(Function<Path, Boolean> pathValidation) {
        this.pathValidation = pathValidation;
    }

    protected boolean isValid(Path selectedPath) {
        if (this.pathValidation == null) {
            return true;
        }
        return this.pathValidation.apply(selectedPath);
    }

    protected void selectFolder(Shell shell) {
        String pathFilter = this.text.getText() == null ? "" : this.text.getText();
        this.dialogService.selectDirectory(shell, pathFilter).ifPresent(selectedName -> {
            Path selectedPath = Paths.get(selectedName, new String[0]);
            if (this.isValid(selectedPath)) {
                this.path = selectedPath;
                this.text.setText(this.path.toString());
                this.text.setToolTipText(this.path.toString());
            }
        });
    }
}

