/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.fileservice;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.core.fileservice.GuidCache;
import org.eclipse.set.model.planpro.BasisTypen.BasisTypenPackage;
import org.eclipse.set.model.planpro.BasisTypen.ID_Bearbeitungsvermerk_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.Zeiger_TypeClass;
import org.eclipse.set.model.planpro.Layoutinformationen.PlanPro_Layoutinfo;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.Verweise.VerweisePackage;

public class ToolboxIDResolver {
    private final GuidCache guidCache = new GuidCache();
    private static final String PLANPRO_ID_REFERENCE_ANNOTATION_SOURCE = "planpro/id_reference";

    private ToolboxIDResolver(PlanPro_Schnittstelle model) {
        this.guidCache.prepare(model);
    }

    private ToolboxIDResolver(PlanPro_Layoutinfo model) {
        this.guidCache.prepare(model);
    }

    public static void resolveIDReferences(PlanPro_Schnittstelle model) {
        ToolboxIDResolver.resolveIDReferences((EObject)model, new ToolboxIDResolver(model));
    }

    public static void resolveIDReferences(PlanPro_Layoutinfo model) {
        ToolboxIDResolver.resolveIDReferences((EObject)model, new ToolboxIDResolver(model));
    }

    private static void resolveIDReferences(EObject model, ToolboxIDResolver resolver) {
        EClass pointer = BasisTypenPackage.eINSTANCE.getZeiger_TypeClass();
        EClass bearbeitungsvermerk = BasisTypenPackage.eINSTANCE.getID_Bearbeitungsvermerk_TypeClass();
        model.eAllContents().forEachRemaining(eo -> {
            if (pointer.isSuperTypeOf(eo.eClass())) {
                resolver.resolveIDReference((Zeiger_TypeClass)eo);
                return;
            }
            if (bearbeitungsvermerk.equals(eo.eClass())) {
                resolver.resolveIDReference((ID_Bearbeitungsvermerk_TypeClass)eo);
                return;
            }
        });
    }

    private static EReference getValueFeature(EObject ref) {
        return (EReference)ref.eClass().getEStructuralFeature(VerweisePackage.eINSTANCE.getID_Anforderer_Element_TypeClass_Value().getName());
    }

    private static EStructuralFeature getValidFeature(EObject ref) {
        return ref.eClass().getEStructuralFeature(VerweisePackage.eINSTANCE.getID_Anforderer_Element_TypeClass_InvalidReference().getName());
    }

    private void resolveIDReference(Zeiger_TypeClass ref) {
        this.resolveIDReference((EObject)ref, ref.getWert());
    }

    private void resolveIDReference(ID_Bearbeitungsvermerk_TypeClass ref) {
        this.resolveIDReference((EObject)ref, ref.getWert());
    }

    private void resolveIDReference(EObject ref, String guid) {
        if (guid == null) {
            return;
        }
        EObject value = this.guidCache.get(guid, ref);
        if (value != null) {
            ToolboxIDResolver.setIDReference(ref, value);
            return;
        }
        ref.eSet(ToolboxIDResolver.getValidFeature(ref), (Object)Boolean.TRUE);
        ref.eSet((EStructuralFeature)ToolboxIDResolver.getValueFeature(ref), null);
    }

    private static void setIDReference(EObject ref, EObject value) {
        boolean isValid = false;
        Optional<EAnnotation> idReferenceAnnotation = ref.eClass().getEAnnotations().stream().filter(annotation -> annotation.getSource().equals(PLANPRO_ID_REFERENCE_ANNOTATION_SOURCE)).findFirst();
        if (idReferenceAnnotation.isPresent()) {
            EList references = idReferenceAnnotation.get().getReferences();
            isValid = references.stream().filter(EClass.class::isInstance).anyMatch(reference -> ToolboxIDResolver.isValidReference((EClass)reference, value));
        } else {
            EReference valueFeature = ToolboxIDResolver.getValueFeature(ref);
            isValid = ToolboxIDResolver.isValidReference(valueFeature.getEReferenceType(), value);
        }
        if (!isValid) {
            ref.eSet(ToolboxIDResolver.getValidFeature(ref), (Object)Boolean.TRUE);
            ref.eSet((EStructuralFeature)ToolboxIDResolver.getValueFeature(ref), null);
            return;
        }
        ref.eSet((EStructuralFeature)ToolboxIDResolver.getValueFeature(ref), (Object)value);
    }

    private static boolean isValidReference(EClass refClass, EObject value) {
        Class<?> valueClass = value.getClass();
        Class referenceClass = refClass.getInstanceClass();
        return referenceClass.isAssignableFrom(valueClass);
    }
}

