/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.track;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.Range;
import org.eclipse.set.feature.overviewplan.track.MetaDataCache;
import org.eclipse.set.feature.overviewplan.track.OverviewplanTrack;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.feature.overviewplan.track.TopKanteDirectedGraph;
import org.eclipse.set.feature.overviewplan.track.TopKnotenPosition;
import org.eclipse.set.feature.overviewplan.track.TrackNetworkService;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TrackNetworkServiceImpl
implements TrackNetworkService {
    private static final Logger logger = LoggerFactory.getLogger(TrackNetworkServiceImpl.class);
    private List<OverviewplanTrack> tracksCache = CollectionLiterals.newArrayList();
    private TopKnotenPosition topKnotenPosition;

    @Override
    public List<OverviewplanTrack> getTracksCache() {
        return this.tracksCache;
    }

    @Override
    public TOPKanteMetaData getTOPKanteMetaData(TOP_Kante topKante) {
        TOPKanteMetaData value = MetaDataCache.getMetaData(topKante);
        if (value != null) {
            return value;
        }
        TOPKanteMetaData metadata = new TOPKanteMetaData(topKante);
        MetaDataCache.setMetaData(topKante, metadata);
        return metadata;
    }

    @Override
    public TOPKanteMetaData getTOPKanteMetaData(List<TOP_Kante> topKanten, String guid) {
        Functions.Function1 _function = it -> {
            Identitaet_TypeClass _identitaet = it.getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            return Objects.equals(_wert, guid);
        };
        TOP_Kante _findFirst = (TOP_Kante)IterableExtensions.findFirst(topKanten, (Functions.Function1)_function);
        TOPKanteMetaData _tOPKanteMetaData = null;
        if (_findFirst != null) {
            _tOPKanteMetaData = this.getTOPKanteMetaData(_findFirst);
        }
        return _tOPKanteMetaData;
    }

    @Override
    public List<TOPKanteMetaData> getTOPKanteMetaData(TOP_Knoten topKnoten) {
        Functions.Function1 _function = it -> this.getTOPKanteMetaData((TOP_Kante)it);
        return ListExtensions.map((List)TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten), (Functions.Function1)_function);
    }

    @Override
    public void setupTrackNet(MultiContainer_AttributeGroup container) {
        boolean _tripleEquals;
        TopKnotenPosition _topKnotenPosition;
        TOPKanteMetaData md;
        TOP_Kante _get = ((TOP_Kante[])Conversions.unwrapArray((Object)container.getTOPKante(), TOP_Kante.class))[0];
        TOPKanteMetaData _tOPKanteMetaData = null;
        if (_get != null) {
            _tOPKanteMetaData = this.getTOPKanteMetaData(_get);
        }
        if ((md = _tOPKanteMetaData) == null) {
            return;
        }
        OverviewplanTrack firstTrack = this.defineTrack(md, 0);
        firstTrack.fixedLvl = true;
        boolean _isMissingTOPKanteMetaData = this.isMissingTOPKanteMetaData(container);
        if (_isMissingTOPKanteMetaData) {
            logger.warn("This model give more than one gleis network");
            this.setupAnotherTrackNet(container);
        }
        Functions.Function1 _function = it -> MetaDataCache.getMetaData(it);
        List topEdges = IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)container.getTOPKante(), (Functions.Function1)_function)));
        TopKanteDirectedGraph topGraph = new TopKanteDirectedGraph();
        Consumer<OverviewplanTrack> _function_1 = track -> {
            Consumer<TOPKanteMetaData> _function_2 = it -> topGraph.addEdge((TOPKanteMetaData)it);
            track.getTopEdges().forEach(_function_2);
        };
        this.tracksCache.forEach(_function_1);
        Consumer<TOPKanteMetaData> _function_2 = it -> topGraph.findTopKanteLength((TOPKanteMetaData)it);
        topEdges.forEach(_function_2);
        TOP_Knoten _topNodeA = ((TOPKanteMetaData)topEdges.get(0)).getTopNodeA();
        this.topKnotenPosition = _topKnotenPosition = new TopKnotenPosition(this, _topNodeA);
        int _size = this.tracksCache.size();
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            return;
        }
        this.defineTrackLvl();
    }

    private boolean isMissingTOPKanteMetaData(MultiContainer_AttributeGroup container) {
        Functions.Function1 _function = it -> {
            TOPKanteMetaData _metaData = MetaDataCache.getMetaData(it);
            return _metaData == null;
        };
        return IterableExtensions.exists((Iterable)container.getTOPKante(), (Functions.Function1)_function);
    }

    private void setupAnotherTrackNet(MultiContainer_AttributeGroup container) {
        boolean _not;
        boolean _isMissingTOPKanteMetaData = this.isMissingTOPKanteMetaData(container);
        boolean bl = _not = !_isMissingTOPKanteMetaData;
        if (_not) {
            return;
        }
        logger.warn("It give more than one track network");
        Object[] clone = (OverviewplanTrack[])((OverviewplanTrack[])Conversions.unwrapArray(this.tracksCache, OverviewplanTrack.class)).clone();
        List<TOPKanteMetaData> cloneMd = MetaDataCache.getAllMetaData(container);
        ArrayList<OverviewplanTrack> _arrayList = new ArrayList<OverviewplanTrack>();
        this.tracksCache = _arrayList;
        MetaDataCache.clearCache(container);
        Functions.Function1 _function = it -> {
            TOPKanteMetaData _metaData = MetaDataCache.getMetaData(it);
            return _metaData == null;
        };
        TOPKanteMetaData md = this.getTOPKanteMetaData((TOP_Kante)IterableExtensions.findFirst((Iterable)container.getTOPKante(), (Functions.Function1)_function));
        this.defineTrack(md, 0);
        List<TOPKanteMetaData> newMetadataSet = MetaDataCache.getAllMetaData(container);
        if (this.tracksCache.size() < ((List)Conversions.doWrapArray((Object)clone)).size() && newMetadataSet.size() < cloneMd.size()) {
            ArrayList<OverviewplanTrack> _arrayList_1 = new ArrayList<OverviewplanTrack>();
            this.tracksCache = _arrayList_1;
            CollectionExtensions.addAll(this.tracksCache, (Object[])clone);
            MetaDataCache.clearCache(container);
            Consumer<TOPKanteMetaData> _function_1 = it -> MetaDataCache.setMetaData(it.getTopEdge(), it);
            cloneMd.forEach(_function_1);
        }
    }

    private OverviewplanTrack defineTrack(TOPKanteMetaData md, int lvl) {
        OverviewplanTrack _overviewplanTrack;
        Functions.Function1 _function = it -> it.getTopEdges().contains(md);
        OverviewplanTrack track = (OverviewplanTrack)IterableExtensions.findFirst(this.tracksCache, (Functions.Function1)_function);
        if (track != null) {
            return track;
        }
        track = _overviewplanTrack = new OverviewplanTrack(md);
        track.lvl = lvl;
        this.tracksCache.add(track);
        this.defineTrackSide(track, md, md.getTopNodeA());
        this.defineTrackSide(track, md, md.getTopNodeB());
        return track;
    }

    private void defineTrackSide(OverviewplanTrack track, TOPKanteMetaData md, TOP_Knoten topNode) {
        TOPKanteMetaData continuous;
        List<TOPKanteMetaData> rightSide;
        Boolean isChangeLeftRight = md.getChangeLeftRightAt(topNode);
        Consumer<TOPKanteMetaData> _function = intersect -> intersect.setChangeLeftRightAt(topNode, isChangeLeftRight);
        md.getIntersectEdgeAt(topNode).forEach(_function);
        List<TOPKanteMetaData> leftSide = md.getLeftEdgeAt(topNode);
        if (leftSide != null) {
            Consumer<TOPKanteMetaData> _function_1 = leftIntersect -> {
                OverviewplanTrack leftTrack = this.defineTrack((TOPKanteMetaData)leftIntersect, overviewplanTrack.lvl + 1);
                if (overviewplanTrack.lvl + 1 > leftTrack.lvl) {
                    leftTrack.lvl = overviewplanTrack.lvl + 1;
                }
                leftTrack.rightTracks.put(topNode, track);
                overviewplanTrack.leftTracks.put(topNode, leftTrack);
            };
            leftSide.forEach(_function_1);
        }
        if ((rightSide = md.getRightEdgeAt(topNode)) != null) {
            Consumer<TOPKanteMetaData> _function_2 = rightIntersect -> {
                OverviewplanTrack rightTrack = this.defineTrack((TOPKanteMetaData)rightIntersect, overviewplanTrack.lvl - 1);
                if (overviewplanTrack.lvl - 1 < rightTrack.lvl) {
                    rightTrack.lvl = overviewplanTrack.lvl - 1;
                }
                rightTrack.leftTracks.put(topNode, track);
                overviewplanTrack.rightTracks.put(topNode, rightTrack);
            };
            rightSide.forEach(_function_2);
        }
        if ((continuous = md.getContinuousEdgeAt(topNode)) != null) {
            this.defineTrackSide(track, continuous, continuous.getNextTopNode(topNode));
        }
    }

    private void defineTrackLvl() {
        Map<TOP_Knoten, Double> topNodeHorizontalCoors = this.topKnotenPosition.findAllTOPNodeHorizontalCoor();
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = node -> (Double)topNodeHorizontalCoors.get(node);
            List nodePositions = ListExtensions.map(it.getTopNodes(), (Functions.Function1)_function_1);
            if (IterableExtensions.isNullOrEmpty((Iterable)nodePositions) || nodePositions.contains(null)) {
                InputOutput.println((Object)"TEST");
            }
            Range _of = Range.of((Comparable)((Double)IterableExtensions.min((Iterable)nodePositions)), (Comparable)((Double)IterableExtensions.max((Iterable)nodePositions)));
            return new Pair(it, (Object)_of);
        };
        List tracksPositionRange = ListExtensions.map(this.tracksCache, (Functions.Function1)_function);
        Consumer<Pair> _function_1 = current -> {
            Functions.Function1 _function_2 = it -> it.getKey() != current.getKey() && ((OverviewplanTrack)it.getKey()).lvl * ((OverviewplanTrack)pair.getKey()).lvl >= 0;
            this.defineTrackLvl((Pair<OverviewplanTrack, Range<Double>>)current, IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)tracksPositionRange, (Functions.Function1)_function_2)));
        };
        tracksPositionRange.forEach(_function_1);
    }

    private void defineTrackLvl(Pair<OverviewplanTrack, Range<Double>> current, List<Pair<OverviewplanTrack, Range<Double>>> compareTracks) {
        int tmpLvl = ((OverviewplanTrack)current.getKey()).lvl;
        Functions.Function1 _function = it -> {
            CollisionType _detectCollision = this.detectCollision(current, (Pair<OverviewplanTrack, Range<Double>>)it);
            return new Pair(it, (Object)_detectCollision);
        };
        Functions.Function1 _function_1 = it -> {
            CollisionType _value = (CollisionType)((Object)((Object)it.getValue()));
            return _value != CollisionType.NONE;
        };
        List collisionsTracks = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(compareTracks, (Functions.Function1)_function), (Functions.Function1)_function_1));
        Consumer<Pair> _function_2 = it -> {
            block17: {
                block16: {
                    Pair collisionTrack = (Pair)it.getKey();
                    CollisionType collisionType = (CollisionType)((Object)((Object)it.getValue()));
                    if (((OverviewplanTrack)pair.getKey()).lvl != tmpLvl) {
                        return;
                    }
                    int _abs = Math.abs(((OverviewplanTrack)collisionTrack.getKey()).lvl - ((OverviewplanTrack)pair.getKey()).lvl);
                    int difference = _abs + 1;
                    if (collisionType == null) break block16;
                    switch (collisionType) {
                        case LEFT: {
                            boolean _not;
                            boolean _changeTrackLvl = this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, true);
                            boolean bl = _not = !_changeTrackLvl;
                            if (_not) {
                                this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, false);
                            }
                            break block17;
                        }
                        case RIGHT: {
                            boolean _not_1;
                            boolean _changeTrackLvl_1 = this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, false);
                            boolean bl = _not_1 = !_changeTrackLvl_1;
                            if (_not_1) {
                                this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, true);
                            }
                            break block17;
                        }
                        case CONTAINS: {
                            boolean _containsRange = ((Range)current.getValue()).containsRange((Range)collisionTrack.getValue());
                            if (_containsRange) {
                                boolean _not_2;
                                boolean _changeTrackLvl_2 = this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, true);
                                boolean bl = _not_2 = !_changeTrackLvl_2;
                                if (_not_2) {
                                    this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, false);
                                }
                            } else {
                                boolean _not_3;
                                boolean _changeTrackLvl_3 = this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, true);
                                boolean bl = _not_3 = !_changeTrackLvl_3;
                                if (_not_3) {
                                    this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, false);
                                }
                            }
                            break block17;
                        }
                        case OVERLAP: {
                            boolean _changeTrackLvl_4;
                            boolean _not_4;
                            OverviewplanTrack _key = (OverviewplanTrack)current.getKey();
                            OverviewplanTrack _key_1 = (OverviewplanTrack)collisionTrack.getKey();
                            Functions.Function1 _function_3 = it_1 -> {
                                boolean _xifexpression = false;
                                _xifexpression = ((OverviewplanTrack)pair.getKey()).lvl > 0 ? it_1.leftTracks.isEmpty() : it_1.rightTracks.isEmpty();
                                return _xifexpression;
                            };
                            OverviewplanTrack emptySideTrack = (OverviewplanTrack)IterableExtensions.findFirst(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new OverviewplanTrack[]{_key, _key_1})), (Functions.Function1)_function_3);
                            if (emptySideTrack != null) {
                                boolean fixed = false;
                                OverviewplanTrack _key_2 = (OverviewplanTrack)current.getKey();
                                boolean _tripleEquals = _key_2 == emptySideTrack;
                                fixed = _tripleEquals ? this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, true) : this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, true);
                                if (fixed) {
                                    return;
                                }
                            }
                            boolean bl = _not_4 = !(_changeTrackLvl_4 = this.changeTrackLvl((OverviewplanTrack)collisionTrack.getKey(), difference, true));
                            if (_not_4) {
                                this.changeTrackLvl((OverviewplanTrack)current.getKey(), difference, true);
                            }
                            break block17;
                        }
                        default: {
                            return;
                        }
                    }
                }
                return;
            }
        };
        collisionsTracks.forEach(_function_2);
        if (((OverviewplanTrack)current.getKey()).lvl != tmpLvl) {
            this.defineTrackLvl(current, compareTracks);
        }
    }

    private boolean changeTrackLvl(OverviewplanTrack track, int value, boolean isIncrease) {
        boolean _not;
        if (track.fixedLvl) {
            return false;
        }
        int _lvl = track.lvl;
        int _xifexpression = 0;
        _xifexpression = isIncrease ? 1 : -1;
        int _multiply = value * _xifexpression;
        track.lvl = _lvl + _multiply;
        Map<TOP_Knoten, OverviewplanTrack> _xifexpression_1 = null;
        _xifexpression_1 = isIncrease ? track.leftTracks : track.rightTracks;
        Map<TOP_Knoten, OverviewplanTrack> nextSideTracks = _xifexpression_1;
        Functions.Function1 _function = it -> {
            boolean _xifexpression_2 = false;
            _xifexpression_2 = isIncrease ? it.lvl > overviewplanTrack.lvl : it.lvl < overviewplanTrack.lvl;
            return _xifexpression_2;
        };
        boolean _forall = IterableExtensions.forall(nextSideTracks.values(), (Functions.Function1)_function);
        boolean bl = _not = !_forall;
        if (_not) {
            Set<OverviewplanTrack> sideTracks = this.getSideTracks(track, isIncrease);
            Consumer<OverviewplanTrack> _function_1 = it -> {
                int _lvl_1 = it.lvl;
                int _xifexpression_2 = 0;
                _xifexpression_2 = isIncrease ? 1 : -1;
                int _multiply_1 = value * _xifexpression_2;
                it.lvl = _lvl_1 + _multiply_1;
            };
            sideTracks.forEach(_function_1);
        }
        return true;
    }

    private CollisionType detectCollision(Pair<OverviewplanTrack, Range<Double>> source, Pair<OverviewplanTrack, Range<Double>> target) {
        int _abs_1;
        boolean isTargetLvlGreater;
        Set<OverviewplanTrack> leftTracks = this.getSideTracks((OverviewplanTrack)source.getKey(), true);
        Set<OverviewplanTrack> rightTracks = this.getSideTracks((OverviewplanTrack)source.getKey(), false);
        if (leftTracks.contains(target.getKey()) && ((OverviewplanTrack)target.getKey()).lvl <= ((OverviewplanTrack)source.getKey()).lvl) {
            return CollisionType.LEFT;
        }
        if (rightTracks.contains(target.getKey()) && ((OverviewplanTrack)target.getKey()).lvl >= ((OverviewplanTrack)source.getKey()).lvl) {
            return CollisionType.RIGHT;
        }
        Range sourceRange = (Range)source.getValue();
        Range targetRange = (Range)target.getValue();
        if (((OverviewplanTrack)source.getKey()).lvl * ((OverviewplanTrack)target.getKey()).lvl < 0) {
            return CollisionType.NONE;
        }
        int _abs = Math.abs(((OverviewplanTrack)source.getKey()).lvl);
        boolean bl = isTargetLvlGreater = _abs <= (_abs_1 = Math.abs(((OverviewplanTrack)target.getKey()).lvl));
        if (sourceRange.isStartedBy((Object)((Double)targetRange.getMinimum())) && sourceRange.isEndedBy((Object)((Double)targetRange.getMaximum()))) {
            CollisionType _xifexpression = null;
            _xifexpression = ((OverviewplanTrack)source.getKey()).lvl == ((OverviewplanTrack)target.getKey()).lvl ? CollisionType.CONTAINS : CollisionType.NONE;
            return _xifexpression;
        }
        boolean _and = false;
        boolean _and_1 = false;
        boolean _containsRange = sourceRange.containsRange(targetRange);
        if (!_containsRange) {
            _and_1 = false;
        } else {
            boolean _contains_1;
            boolean _contains;
            boolean _xifexpression_1 = false;
            _xifexpression_1 = ((OverviewplanTrack)source.getKey()).lvl > 0 ? !(_contains = leftTracks.contains(target.getKey())) : !(_contains_1 = rightTracks.contains(target.getKey()));
            _and_1 = _xifexpression_1;
        }
        _and = !_and_1 ? false : isTargetLvlGreater;
        if (_and) {
            return CollisionType.CONTAINS;
        }
        boolean _and_2 = false;
        boolean _and_3 = false;
        boolean _containsRange_1 = targetRange.containsRange(sourceRange);
        if (!_containsRange_1) {
            _and_3 = false;
        } else {
            boolean _contains_3;
            boolean _contains_2;
            boolean _xifexpression_2 = false;
            _xifexpression_2 = ((OverviewplanTrack)source.getKey()).lvl > 0 ? !(_contains_2 = rightTracks.contains(target.getKey())) : !(_contains_3 = leftTracks.contains(target.getKey()));
            _and_3 = _xifexpression_2;
        }
        if (!_and_3) {
            _and_2 = false;
        } else {
            boolean bl2 = _and_2 = !isTargetLvlGreater;
        }
        if (_and_2) {
            return CollisionType.CONTAINS;
        }
        if (sourceRange.isOverlappedBy(targetRange) && ((OverviewplanTrack)source.getKey()).lvl == ((OverviewplanTrack)target.getKey()).lvl) {
            return CollisionType.OVERLAP;
        }
        return CollisionType.NONE;
    }

    private Set<OverviewplanTrack> getSideTracks(OverviewplanTrack mdTrack, boolean isLeftSide) {
        Map<TOP_Knoten, OverviewplanTrack> _xifexpression = null;
        _xifexpression = isLeftSide ? mdTrack.leftTracks : mdTrack.rightTracks;
        Map<TOP_Knoten, OverviewplanTrack> sideTrack = _xifexpression;
        boolean _isEmpty = sideTrack.values().isEmpty();
        if (_isEmpty) {
            return Collections.emptySet();
        }
        HashSet result = CollectionLiterals.newHashSet();
        result.addAll(sideTrack.values());
        Consumer<OverviewplanTrack> _function = it -> result.addAll(this.getSideTracks((OverviewplanTrack)it, isLeftSide));
        sideTrack.values().forEach(_function);
        return result;
    }

    @Override
    public OverviewplanTrack getTrack(TOPKanteMetaData md) {
        Functions.Function1 _function = it -> it.getTopEdges().contains(md);
        return (OverviewplanTrack)IterableExtensions.findFirst(this.tracksCache, (Functions.Function1)_function);
    }

    @Override
    public void clean(MultiContainer_AttributeGroup container) {
        MetaDataCache.clearCache(container);
        this.tracksCache = CollectionLiterals.newArrayList();
        this.topKnotenPosition = null;
    }

    @Override
    public Position getTOPNodePosition(TOP_Knoten node, OverviewplanTrack track) {
        return this.topKnotenPosition.getTopNodePosition(node, track);
    }

    private static enum CollisionType {
        LEFT,
        RIGHT,
        OVERLAP,
        CONTAINS,
        NONE;

    }
}

