/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Anlage;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Anlage_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Kante_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Bahnsteig.Bezeichnung_Bahnsteig_Anlage_TypeClass;
import org.eclipse.set.model.planpro.Bahnsteig.Bezeichnung_Bahnsteig_Kante_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Knoten_TypeClass;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.Platform;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.Station;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class StationTransformator
extends BaseTransformator<Bahnsteig_Anlage> {
    @Reference
    private GeoKanteGeometryService geometryService;
    @Reference
    private PositionService positionService;
    private static final BigDecimal STATION_TRACK_DISTANCE = BigDecimal.valueOf(1.7);

    @Override
    public void transform(Bahnsteig_Anlage station) {
        Station result = SiteplanFactory.eINSTANCE.createStation();
        Identitaet_TypeClass _identitaet = station.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Bahnsteig_Anlage_Bezeichnung_AttributeGroup _bezeichnung = station.getBezeichnung();
        Bezeichnung_Bahnsteig_Anlage_TypeClass _bezeichnungBahnsteigAnlage = null;
        if (_bezeichnung != null) {
            _bezeichnungBahnsteigAnlage = _bezeichnung.getBezeichnungBahnsteigAnlage();
        }
        String _wert_1 = null;
        if (_bezeichnungBahnsteigAnlage != null) {
            _wert_1 = _bezeichnungBahnsteigAnlage.getWert();
        }
        _label.setText(_wert_1);
        Functions.Function1 _function = it -> {
            Bahnsteig_Anlage _value = it.getIDBahnsteigAnlage().getValue();
            return _value == station;
        };
        Functions.Function1 _function_1 = it -> this.transform((Bahnsteig_Kante)it);
        Iterables.addAll((Collection)result.getPlatforms(), (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)station).getBahnsteigKante(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_Stations());
    }

    public Platform transform(Bahnsteig_Kante platform) {
        Platform result = SiteplanFactory.eINSTANCE.createPlatform();
        Identitaet_TypeClass _identitaet = platform.getIdentitaet();
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        result.setGuid(_wert);
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Bahnsteig_Kante_Bezeichnung_AttributeGroup _bezeichnung = platform.getBezeichnung();
        Bezeichnung_Bahnsteig_Kante_TypeClass _bezeichnungBahnsteigKante = null;
        if (_bezeichnung != null) {
            _bezeichnungBahnsteigKante = _bezeichnung.getBezeichnungBahnsteigKante();
        }
        String _wert_1 = null;
        if (_bezeichnungBahnsteigKante != null) {
            _wert_1 = _bezeichnungBahnsteigKante.getWert();
        }
        _label.setText(_wert_1);
        Consumer<Bereich_Objekt_Teilbereich_AttributeGroup> _function = tb -> {
            ENUMWirkrichtung _wert_3;
            boolean _tripleEquals_1;
            boolean _tripleEquals;
            BigDecimal lateralDistance = STATION_TRACK_DISTANCE;
            ENUMLinksRechts _wert_2 = platform.getBahnsteigKanteAllg().getLageZumGleis().getWert();
            boolean bl = _tripleEquals = _wert_2 == ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS;
            if (_tripleEquals) {
                BigDecimal _minus;
                lateralDistance = _minus = lateralDistance.negate();
            }
            boolean bl2 = _tripleEquals_1 = (_wert_3 = tb.getRichtungsbezug().getWert()) == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN;
            if (_tripleEquals_1) {
                BigDecimal _minus_1;
                lateralDistance = _minus_1 = lateralDistance.negate();
            }
            ID_TOP_Kante_TypeClass _iDTOPKante = null;
            if (tb != null) {
                _iDTOPKante = tb.getIDTOPKante();
            }
            TOP_Kante _value = null;
            if (_iDTOPKante != null) {
                _value = _iDTOPKante.getValue();
            }
            TOP_Kante topKante = _value;
            ID_TOP_Knoten_TypeClass _iDTOPKnotenA = null;
            if (topKante != null) {
                _iDTOPKnotenA = topKante.getIDTOPKnotenA();
            }
            TOP_Knoten _value_1 = null;
            if (_iDTOPKnotenA != null) {
                _value_1 = _iDTOPKnotenA.getValue();
            }
            GEOKanteCoordinate start = this.geometryService.getCoordinate(topKante, _value_1, tb.getBegrenzungA().getWert(), lateralDistance, tb.getRichtungsbezug().getWert());
            ID_TOP_Knoten_TypeClass _iDTOPKnotenA_1 = null;
            if (topKante != null) {
                _iDTOPKnotenA_1 = topKante.getIDTOPKnotenA();
            }
            TOP_Knoten _value_2 = null;
            if (_iDTOPKnotenA_1 != null) {
                _value_2 = _iDTOPKnotenA_1.getValue();
            }
            GEOKanteCoordinate end = this.geometryService.getCoordinate(topKante, _value_2, tb.getBegrenzungB().getWert(), lateralDistance, tb.getRichtungsbezug().getWert());
            result.getPoints().add((Object)this.positionService.transformPosition(start));
            result.getPoints().add((Object)this.positionService.transformPosition(end));
        };
        platform.getBereichObjektTeilbereich().forEach(_function);
        return result;
    }
}

