/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.feature.projectdata.Messages;
import org.eclipse.set.utils.widgets.ComboValues;

public enum ContainerComboSelection {
    NOT_SELECTED,
    START,
    ZIEL,
    ZUSTAND_INFORMATION;


    public static ComboValues<ContainerComboSelection> getComboValues(PlanProFileNature fileNature, Messages messages) {
        return new ContainerComboValues(fileNature, messages);
    }

    public static ComboValues<ContainerComboSelection> getDefaultValues(Messages messages) {
        return new ContainerComboValues(PlanProFileNature.INVALID, messages);
    }

    private static class ContainerComboValues
    implements ComboValues<ContainerComboSelection> {
        private final PlanProFileNature fileNature;
        private String[] itemsMessages;
        private ContainerComboSelection[] itemValues;
        private final Messages messages;

        public ContainerComboValues(PlanProFileNature fileNature, Messages messages) {
            this.fileNature = fileNature;
            this.messages = messages;
            this.createItems();
        }

        public int getDefaultIndex() {
            if (this.fileNature == PlanProFileNature.INFORMATION_STATE) {
                return this.getIndex(ZUSTAND_INFORMATION);
            }
            return this.getIndex(NOT_SELECTED);
        }

        public String getDefaultValue() {
            return this.getMessage(NOT_SELECTED);
        }

        public int getIndex(ContainerComboSelection value) {
            return Arrays.asList(this.itemValues).indexOf((Object)value);
        }

        public int getIndex(String stringValue) {
            return ArrayUtils.indexOf((Object[])this.itemsMessages, (Object)stringValue);
        }

        public String[] getComboValues() {
            return this.itemsMessages;
        }

        public String[] getValuesWithoutDefault() {
            return (String[])ArrayUtils.removeElement((Object[])this.itemsMessages, (Object)((Object)this.getValue(this.getDefaultIndex())));
        }

        public ContainerComboSelection getValue(int selectionIndex) {
            return this.itemValues[selectionIndex];
        }

        public ContainerComboSelection getValue(String valueString) {
            ContainerComboSelection[] containerComboSelectionArray = this.itemValues;
            int n = this.itemValues.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerComboSelection value = containerComboSelectionArray[n2];
                if (this.getMessage(value).equals(valueString)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }

        public int size() {
            return this.itemValues.length;
        }

        private void createItems() {
            switch (this.fileNature) {
                case INVALID: {
                    this.createItems(NOT_SELECTED);
                    break;
                }
                case INFORMATION_STATE: {
                    this.createItems(ZUSTAND_INFORMATION);
                    break;
                }
                case PLANNING: {
                    this.createItems(NOT_SELECTED, START, ZIEL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.fileNature.toString());
                }
            }
        }

        private void createItems(ContainerComboSelection ... values) {
            this.itemValues = new ContainerComboSelection[values.length];
            this.itemsMessages = new String[values.length];
            int i = 0;
            while (i < values.length) {
                this.itemValues[i] = values[i];
                this.itemsMessages[i] = this.getMessage(values[i]);
                ++i;
            }
        }

        private String getMessage(ContainerComboSelection value) {
            switch (value) {
                case NOT_SELECTED: {
                    return this.messages.ContainerValues_NotSelected;
                }
                case START: {
                    return this.messages.ContainerValues_Start;
                }
                case ZIEL: {
                    return this.messages.ContainerValues_Ziel;
                }
                case ZUSTAND_INFORMATION: {
                    return this.messages.ContainerValues_ZustandInformation;
                }
            }
            throw new IllegalArgumentException(value.toString());
        }

        public String getMaxLengthItem() {
            return List.of(this.getMessage(NOT_SELECTED), this.getMessage(START), this.getMessage(ZIEL), this.getMessage(ZUSTAND_INFORMATION)).stream().reduce((a, b) -> a.length() > b.length() ? a : b).orElse(this.getDefaultValue());
        }
    }
}

