/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.view.control.multiattribute;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPObservableValue;
import org.eclipse.emf.ecp.edit.spi.swt.table.ECPCellEditor;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.model.common.util.RendererUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.RenderMode;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStyleProperty;
import org.eclipse.emf.ecp.view.template.style.tableStyleProperty.model.VTTableStylePropertyFactory;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.internal.view.control.multiattribute.Messages;
import org.eclipse.emfforms.internal.view.control.multiattribute.celleditor.CellEditorFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerRow;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.FrameworkUtil;

public class MultiAttributeSWTRenderer
extends AbstractControlSWTRenderer<VControl> {
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private static final String ICONS_ARROW_DOWN_PNG = "icons/arrow_down.png";
    private static final String ICONS_ARROW_UP_PNG = "icons/arrow_up.png";
    private final ImageRegistryService imageRegistryService;
    private AdapterFactoryLabelProvider labelProvider;
    private ComposedAdapterFactory composedAdapterFactory;
    private Composite mainComposite;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;
    private final EMFDataBindingContext viewModelDBC;
    private Label validationIcon;
    private AddButtonSelectionAdapter addButtonSelectionAdapter;
    private RemoveButtonSelectionAdapter removeButtonSelectionAdapter;
    private UpButtonSelectionAdapter upButtonSelectionAdapter;
    private DownButtonSelectionAdapter downButtonSelectionAdapter;
    private ECPListEditingSupport observableSupport;
    private SWTGridDescription rendererGridDescription;
    private Button upButton;
    private Button downButton;

    @Inject
    public MultiAttributeSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, ImageRegistryService imageRegistryService) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.imageRegistryService = imageRegistryService;
        this.viewModelDBC = new EMFDataBindingContext();
    }

    protected VTTableStyleProperty createDefaultTableStyleProperty() {
        return VTTableStylePropertyFactory.eINSTANCE.createTableStyleProperty();
    }

    protected VTTableStyleProperty getTableStyleProperty() {
        VTTableStyleProperty styleProperty = (VTTableStyleProperty)RendererUtil.getStyleProperty((VTViewTemplateProvider)this.getVTViewTemplateProvider(), (VElement)this.getVElement(), (ViewModelContext)this.getViewModelContext(), VTTableStyleProperty.class);
        if (styleProperty == null) {
            styleProperty = this.createDefaultTableStyleProperty();
        }
        return styleProperty;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY ? GridDescriptionFactory.INSTANCE.createCompactGrid(false, true, (AbstractSWTRenderer)this) : GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected int getTableHeightHint() {
        return 200;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected Composite createControlComposite(Composite composite) {
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, this.getTableHeightHint()).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        return controlComposite;
    }

    protected Image getImage(String path) {
        return this.imageRegistryService.getImage(FrameworkUtil.getBundle(MultiAttributeSWTRenderer.class), path);
    }

    private Button createRemoveRowButton(Composite buttonComposite, IObservableList list) {
        EAttribute attribute = (EAttribute)EAttribute.class.cast(list.getElementType());
        Button removeButton = new Button(buttonComposite, 0);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)removeButton, (VElement)this.getVElement(), (String)"remove", (ViewModelContext)this.getViewModelContext());
        Image image = this.getImage(ICON_DELETE);
        removeButton.setImage(image);
        removeButton.setEnabled(!((VControl)this.getVElement()).isEffectivelyReadonly());
        if (list.size() <= attribute.getLowerBound()) {
            removeButton.setEnabled(false);
        }
        return removeButton;
    }

    private Button createAddRowButton(Composite buttonComposite, IObservableList list) {
        EAttribute attribute = (EAttribute)EAttribute.class.cast(list.getElementType());
        Button addButton = new Button(buttonComposite, 0);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)addButton, (VElement)this.getVElement(), (String)"add", (ViewModelContext)this.getViewModelContext());
        Image image = this.getImage(ICON_ADD);
        addButton.setImage(image);
        if (attribute.getUpperBound() != -1 && list.size() >= attribute.getUpperBound()) {
            addButton.setEnabled(false);
        }
        addButton.setToolTipText(Messages.MultiAttributeSWTRenderer_AddButtonTooltip);
        return addButton;
    }

    protected void applyReadOnly() {
        this.updateButtonVisibility();
    }

    protected boolean ignoreEnableOnReadOnly() {
        return false;
    }

    protected void updateButtons() {
        this.updateButtonVisibility();
        this.updateButtonEnabling();
    }

    protected void updateButtonVisibility() {
        boolean isVisible;
        boolean bl = isVisible = !((VControl)this.getVElement()).isEffectivelyReadonly();
        if (this.addButton != null) {
            this.addButton.setVisible(isVisible);
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(isVisible);
        }
        if (this.upButton != null) {
            this.upButton.setVisible(isVisible);
        }
        if (this.downButton != null) {
            this.downButton.setVisible(isVisible);
        }
    }

    protected void updateButtonEnabling() {
        boolean isEnable = ((VControl)this.getVElement()).isEffectivelyEnabled();
        int listSize = this.tableViewer != null ? this.tableViewer.getTable().getItemCount() : 0;
        int selectionIndex = this.tableViewer != null ? this.tableViewer.getTable().getSelectionIndex() : -1;
        this.enableUpButton(isEnable, listSize, selectionIndex);
        this.enableDownButton(isEnable, listSize, selectionIndex);
        this.enableAddButton(isEnable, listSize, selectionIndex);
        this.enableDeleteButton(isEnable, listSize, selectionIndex);
    }

    private void enableUpButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.upButton != null) {
            boolean enabled = baseEnable && listSize > 1 && selectionIndex > 0;
            this.upButton.setEnabled(enabled);
        }
    }

    private void enableDownButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.downButton != null) {
            boolean enabled = baseEnable && listSize > 1 && selectionIndex != -1 && selectionIndex < listSize - 1;
            this.downButton.setEnabled(enabled);
        }
    }

    private void enableAddButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.addButton != null) {
            this.addButton.setEnabled(baseEnable);
        }
    }

    private void enableDeleteButton(boolean baseEnable, int listSize, int selectionIndex) {
        if (this.removeButton != null) {
            this.removeButton.setEnabled(baseEnable && listSize > 0 && selectionIndex != -1);
        }
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoPropertyDescriptorFoundExeption, NoRendererFoundException {
        if (this.rendererGridDescription.getColumns() == 1) {
            return this.renderMultiAttributeControl(cell, parent);
        }
        if (cell.getColumn() == 0 && this.rendererGridDescription.getColumns() > 1) {
            this.validationIcon = this.createValidationIcon(parent);
            GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
            return this.validationIcon;
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        try {
            IObservableList list = this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            Control multiAttributeComposite = this.renderMultiAttributeControl(cell, composite);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(multiAttributeComposite);
            Composite buttonComposite = this.createButtonComposite(composite, list);
            GridDataFactory.fillDefaults().align(0x1000008, 1).grab(false, false).applyTo((Control)buttonComposite);
            this.initButtons(list);
        }
        catch (DatabindingFailedException ex) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return this.createErrorLabel(composite, (Exception)((Object)ex));
        }
        return composite;
    }

    protected Control renderMultiAttributeControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        IObservableList list;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.COMPACT_VERTICALLY) {
            GridLayoutFactory.fillDefaults().applyTo(composite);
        } else {
            composite.setLayout((Layout)new GridLayout(1, false));
        }
        this.createLabelProvider();
        try {
            list = this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex1) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex1));
            return composite;
        }
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.DEFAULT) {
            Composite titleComposite = this.createTitleComposite(composite);
            this.createButtonComposite(titleComposite, list);
        }
        Composite controlComposite = this.createControlComposite(composite);
        this.createContent(controlComposite, list);
        SWTDataElementIdHelper.setElementIdDataForVControl((Widget)composite, (VControl)((VControl)this.getVElement()), (ViewModelContext)this.getViewModelContext());
        if (this.getTableStyleProperty().getRenderMode() == RenderMode.DEFAULT) {
            this.initButtons(list);
        }
        return composite;
    }

    protected Composite createTitleComposite(Composite parent) {
        Composite titleComposite = new Composite(parent, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(titleComposite);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        return titleComposite;
    }

    protected Composite createButtonComposite(Composite parent, IObservableList list) {
        Composite buttonComposite = new Composite(parent, 0);
        EAttribute attribute = (EAttribute)EAttribute.class.cast(list.getElementType());
        buttonComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
        int numButtons = 0;
        if (attribute.isOrdered()) {
            this.createUpDownButtons(buttonComposite, list);
            numButtons += 2;
        }
        this.addButton = this.createAddRowButton(buttonComposite, list);
        this.removeButton = this.createRemoveRowButton(buttonComposite, list);
        GridLayoutFactory.fillDefaults().numColumns(numButtons += 2).equalWidth(false).applyTo(buttonComposite);
        return buttonComposite;
    }

    protected void initButtons(IObservableList list) {
        this.initAddButton(this.addButton, list);
        this.initRemoveButton(this.removeButton, list);
        this.initUpButton(this.upButton, list);
        this.initDownButton(this.downButton, list);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiAttributeSWTRenderer.this.updateButtonEnabling();
            }
        });
        this.updateButtons();
    }

    private void createLabelProvider() {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        this.labelProvider.setFireLabelUpdateNotifications(true);
    }

    private void initAddButton(Button addButton, IObservableList list) {
        if (addButton == null) {
            return;
        }
        this.addButtonSelectionAdapter = new AddButtonSelectionAdapter(list);
        addButton.addSelectionListener((SelectionListener)this.addButtonSelectionAdapter);
    }

    private void initRemoveButton(Button removeButton, IObservableList list) {
        if (removeButton == null) {
            return;
        }
        this.removeButtonSelectionAdapter = new RemoveButtonSelectionAdapter(list);
        removeButton.addSelectionListener((SelectionListener)this.removeButtonSelectionAdapter);
    }

    private void initUpButton(Button upButton, IObservableList list) {
        if (upButton == null) {
            return;
        }
        this.upButtonSelectionAdapter = new UpButtonSelectionAdapter(list);
        upButton.addSelectionListener((SelectionListener)this.upButtonSelectionAdapter);
        upButton.setEnabled(false);
    }

    private void initDownButton(Button downButton, IObservableList list) {
        if (downButton == null) {
            return;
        }
        this.downButtonSelectionAdapter = new DownButtonSelectionAdapter(list);
        downButton.addSelectionListener((SelectionListener)this.downButtonSelectionAdapter);
        downButton.setEnabled(false);
    }

    protected void createUpDownButtons(Composite composite, IObservableList list) {
        Image up = this.getImage(ICONS_ARROW_UP_PNG);
        Image down = this.getImage(ICONS_ARROW_DOWN_PNG);
        this.upButton = new Button(composite, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.upButton, (VElement)this.getVElement(), (String)"up", (ViewModelContext)this.getViewModelContext());
        this.upButton.setImage(up);
        this.upButton.setEnabled(!((VControl)this.getVElement()).isEffectivelyReadonly());
        this.downButton = new Button(composite, 8);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)this.downButton, (VElement)this.getVElement(), (String)"down", (ViewModelContext)this.getViewModelContext());
        this.downButton.setImage(down);
        this.downButton.setEnabled(!((VControl)this.getVElement()).isEffectivelyReadonly());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        Object tempInstance = clazz.isInterface() || clazz.isAbstract() || clazz.getInstanceClass() == null ? new DynamicEObjectImpl(clazz) : EcoreUtil.create((EClass)clazz);
        return (InternalEObject)InternalEObject.class.cast(tempInstance);
    }

    private void createContent(Composite composite, IObservableList list) {
        EAttribute attribute = (EAttribute)EAttribute.class.cast(list.getElementType());
        this.tableViewer = new TableViewer(composite, 68098);
        this.tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_multiattribute");
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                if (((VControl)MultiAttributeSWTRenderer.this.getVElement()).isEffectivelyReadonly()) {
                    return false;
                }
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EMFFormsLabelProvider labelService = this.getEMFFormsLabelProvider();
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setResizable(false);
        column.getColumn().setMoveable(false);
        EClass clazz = attribute.getEContainingClass();
        InternalEObject tempInstance = null;
        if (!clazz.isAbstract() && !clazz.isInterface()) {
            tempInstance = this.getInstanceOf(clazz);
        }
        CellEditor cellEditor = this.createCellEditor((EObject)tempInstance, attribute, this.tableViewer.getTable());
        ISWTObservableValue textObservableValue = WidgetProperties.text().observe((Widget)column.getColumn());
        ISWTObservableValue tooltipObservableValue = WidgetProperties.tooltipText().observe((Widget)column.getColumn());
        try {
            this.viewModelDBC.bindValue((IObservableValue)textObservableValue, labelService.getDisplayName(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
            this.viewModelDBC.bindValue((IObservableValue)tooltipObservableValue, labelService.getDescription(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()));
        }
        catch (NoLabelFoundException e) {
            this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)cp);
        this.tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, false));
        VDomainModelReference dmr = ((VControl)this.getVElement()).getDomainModelReference();
        this.observableSupport = new ECPListEditingSupport((ColumnViewer)this.tableViewer, cellEditor, (VControl)this.getVElement(), dmr, list);
        column.setEditingSupport((EditingSupport)this.observableSupport);
    }

    private CellEditor createCellEditor(EObject tempInstance, EAttribute attribute, Table table) {
        return CellEditorFactory.INSTANCE.createCellEditor(attribute, tempInstance, table, this.getViewModelContext());
    }

    protected Object getValueForNewRow(EAttribute attribute) {
        try {
            Object defaultValue = attribute.getDefaultValue();
            if (defaultValue == null || !attribute.getEType().isInstance(defaultValue)) {
                defaultValue = attribute.getEType().getDefaultValue();
            }
            if (defaultValue == null) {
                defaultValue = attribute.getEType().getInstanceClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return defaultValue;
        }
        catch (InstantiationException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (IllegalAccessException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (IllegalArgumentException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (InvocationTargetException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (NoSuchMethodException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        catch (SecurityException ex) {
            this.getReportService().report(new AbstractReport((Throwable)ex, Messages.MultiAttributeSWTRenderer_AddFailed));
        }
        throw new IllegalStateException();
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MultiAttributeSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (MultiAttributeSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VControl)MultiAttributeSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                MultiAttributeSWTRenderer.this.validationIcon.setImage(MultiAttributeSWTRenderer.this.getValidationIcon());
                MultiAttributeSWTRenderer.this.validationIcon.setToolTipText(ECPTooltipModifierHelper.modifyString((String)((VControl)MultiAttributeSWTRenderer.this.getVElement()).getDiagnostic().getMessage(), null));
            }
        });
    }

    protected void applyEnable() {
        super.applyEnable();
        this.updateButtonEnabling();
    }

    private Button getMoveDownButton() {
        return this.downButton;
    }

    private Button getMoveUpButton() {
        return this.upButton;
    }

    private Button getRemoveButton() {
        return this.removeButton;
    }

    private Button getAddButton() {
        return this.addButton;
    }

    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        super.dispose();
    }

    protected void rootDomainModelChanged() throws DatabindingFailedException {
        IObservableList oldList = (IObservableList)this.getTableViewer().getInput();
        oldList.dispose();
        IObservableList list = this.getEMFFormsDatabinding().getObservableList(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        this.getTableViewer().setInput((Object)list);
        this.addButtonSelectionAdapter.setObservableList(list);
        this.removeButtonSelectionAdapter.setObservableList(list);
        this.upButtonSelectionAdapter.setObservableList(list);
        this.downButtonSelectionAdapter.setObservableList(list);
        this.observableSupport.setObservableList(list);
    }

    protected void postRemove(IStructuredSelection selection) {
    }

    protected Control createErrorLabel(Composite parent, Exception ex) {
        Label errorLabel = new Label(parent, 0);
        errorLabel.setText(ex.getMessage());
        return errorLabel;
    }

    private final class AddButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        AddButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent event) {
            try {
                IObserving observing = (IObserving)IObserving.class.cast(this.list);
                EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
                EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
                Object defaultValue = MultiAttributeSWTRenderer.this.getValueForNewRow(attribute);
                if (defaultValue == null) {
                    return;
                }
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(MultiAttributeSWTRenderer.this.getViewModelContext().getDomainModel());
                editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)attribute, (Object)defaultValue));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private final class DownButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        DownButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            int currentIndex = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelectionIndex();
            if (currentIndex + 1 < MultiAttributeSWTRenderer.this.tableViewer.getTable().getItems().length) {
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
                editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, (EStructuralFeature)attribute, currentIndex, currentIndex + 1));
                MultiAttributeSWTRenderer.this.tableViewer.refresh();
                MultiAttributeSWTRenderer.this.tableViewer.getTable().setSelection(currentIndex + 1);
                TableItem[] selection = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelection();
                if (selection.length > 0) {
                    MultiAttributeSWTRenderer.this.tableViewer.getTable().showItem(selection[0]);
                }
            }
        }
    }

    private class ECPListEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final VControl control;
        private IObservableList valueProperty;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        ECPListEditingSupport(ColumnViewer viewer, CellEditor cellEditor, VControl control, VDomainModelReference domainModelReference, IObservableList valueProperty) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.control = control;
            this.valueProperty = valueProperty;
        }

        protected boolean canEdit(Object element) {
            boolean editable;
            boolean bl = editable = this.control.isEffectivelyEnabled() && !this.control.isEffectivelyReadonly();
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return editable;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            TableViewerRow viewerRow = (TableViewerRow)cell.getViewerRow();
            TableItem item = (TableItem)viewerRow.getItem();
            int index = item.getParent().indexOf(item);
            EAttribute fakeAttribute = (EAttribute)EcoreUtil.copy((EObject)((EAttribute)EAttribute.class.cast(this.valueProperty.getElementType())));
            fakeAttribute.setUpperBound(1);
            fakeAttribute.setLowerBound(0);
            ECPObservableValue model = new ECPObservableValue(this.valueProperty, index, (Object)fakeAttribute);
            Binding binding = this.createBinding(target, (IObservableValue)model);
            this.editingState = new EditingState(binding, target, (IObservableValue)model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return MultiAttributeSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(MultiAttributeSWTRenderer.this.getDataBindingContext()), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy(MultiAttributeSWTRenderer.this.getDataBindingContext()));
            }
            return MultiAttributeSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return WidgetProperties.text((int)16).observe((Widget)cellEditor.getControl());
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        public void setObservableList(IObservableList list) {
            this.valueProperty = list;
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPListEditingSupport.this.editingState.dispose();
                ECPListEditingSupport.this.editingState = null;
                ECPListEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPListEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPListEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private final class RemoveButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        RemoveButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
            IStructuredSelection selection = MultiAttributeSWTRenderer.this.tableViewer.getStructuredSelection();
            if (!selection.isEmpty()) {
                editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)attribute, (Collection)selection.toList()));
                MultiAttributeSWTRenderer.this.postRemove(selection);
            }
        }
    }

    private final class UpButtonSelectionAdapter
    extends SelectionAdapter {
        private IObservableList list;

        UpButtonSelectionAdapter(IObservableList list) {
            this.setObservableList(list);
        }

        public void setObservableList(IObservableList list) {
            this.list = list;
        }

        public void widgetSelected(SelectionEvent e) {
            IObserving observing = (IObserving)IObserving.class.cast(this.list);
            EObject eObject = (EObject)EObject.class.cast(observing.getObserved());
            EAttribute attribute = (EAttribute)EAttribute.class.cast(this.list.getElementType());
            int currentIndex = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelectionIndex();
            if (currentIndex != 0) {
                EditingDomain editingDomain = MultiAttributeSWTRenderer.this.getEditingDomain(eObject);
                editingDomain.getCommandStack().execute((Command)new MoveCommand(editingDomain, eObject, (EStructuralFeature)attribute, currentIndex, currentIndex - 1));
                MultiAttributeSWTRenderer.this.tableViewer.refresh();
                MultiAttributeSWTRenderer.this.tableViewer.getTable().setSelection(currentIndex - 1);
                TableItem[] selection = MultiAttributeSWTRenderer.this.tableViewer.getTable().getSelection();
                if (selection.length > 0) {
                    MultiAttributeSWTRenderer.this.tableViewer.getTable().showItem(selection[0]);
                }
            }
        }
    }
}

