/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.swt.finder.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.swt.finder.ReferenceBy;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.utils.TableRow;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableColumn;
import org.eclipse.swtbot.swt.finder.widgets.SiriusSWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=Table.class, preferredName="table", referenceBy={ReferenceBy.LABEL})
public class SiriusSWTBotTable
extends AbstractSWTBotControl<Table> {
    private TableItem lastSelectionItem;

    public SiriusSWTBotTable(Table table) throws WidgetNotFoundException {
        this(table, null);
    }

    public SiriusSWTBotTable(Table table, SelfDescribing description) throws WidgetNotFoundException {
        super((Control)table, description);
    }

    public int rowCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Table)SiriusSWTBotTable.this.widget).getItemCount();
            }
        });
    }

    public int columnCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Table)SiriusSWTBotTable.this.widget).getColumnCount();
            }
        });
    }

    public List<String> columns() {
        return this.syncExec((ListResult)new ListResult<String>(){

            public List<String> run() {
                ArrayList<String> result = new ArrayList<String>();
                TableColumn[] columns = ((Table)SiriusSWTBotTable.this.widget).getColumns();
                int[] nArray = ((Table)SiriusSWTBotTable.this.widget).getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    result.add(columns[i].getText());
                    ++n2;
                }
                return result;
            }
        });
    }

    public int indexOfColumn(String column) {
        return this.columns().indexOf(column);
    }

    public SWTBotTableColumn header(final String label) throws WidgetNotFoundException {
        TableColumn column = (TableColumn)this.syncExec((Result)new Result<TableColumn>(){

            public TableColumn run() {
                TableColumn[] columns;
                TableColumn[] tableColumnArray = columns = ((Table)SiriusSWTBotTable.this.widget).getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    if (column.getText().equals(label)) {
                        return column;
                    }
                    ++n2;
                }
                return null;
            }
        });
        return new SWTBotTableColumn(column, (Table)this.widget);
    }

    public String cell(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        return this.syncExec(new StringResult(){

            public String run() {
                TableItem item = ((Table)SiriusSWTBotTable.this.widget).getItem(row);
                return item.getText(column);
            }
        });
    }

    public String cell(int row, String columnName) {
        Assert.isLegal((boolean)this.columns().contains(columnName), (Object)("The column `" + columnName + "' is not found."));
        List<String> columns = this.columns();
        int columnIndex = columns.indexOf(columnName);
        if (columnIndex == -1) {
            return "";
        }
        return this.cell(row, columnIndex);
    }

    public int selectionCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Table)SiriusSWTBotTable.this.widget).getSelectionCount();
            }
        });
    }

    public TableCollection selection() {
        final int columnCount = this.columnCount();
        return (TableCollection)this.syncExec((Result)new Result<TableCollection>(){

            public TableCollection run() {
                TableItem[] items;
                TableCollection selection = new TableCollection();
                TableItem[] tableItemArray = items = ((Table)SiriusSWTBotTable.this.widget).getSelection();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    TableRow tableRow = new TableRow();
                    int j = 0;
                    while (j < columnCount) {
                        tableRow.add(item.getText(j));
                        ++j;
                    }
                    selection.add(tableRow);
                    ++n2;
                }
                return selection;
            }
        });
    }

    private void assertIsLegalRowIndex(int rowIndex) {
        Assert.isLegal((rowIndex < this.rowCount() ? 1 : 0) != 0, (Object)("The row number: " + rowIndex + " does not exist in the table"));
    }

    public void select(String ... items) {
        this.waitForEnabled();
        this.setFocus();
        int[] itemIndicies = new int[items.length];
        int i = 0;
        while (i < items.length) {
            itemIndicies[i] = this.indexOf(items[i]);
            Assert.isLegal((itemIndicies[i] >= 0 ? 1 : 0) != 0, (Object)("Could not find item:" + items[i] + " in table"));
            ++i;
        }
        this.select(itemIndicies);
    }

    public int indexOf(final String item) {
        return this.syncExec(new IntResult(){

            public Integer run() {
                TableItem[] items = ((Table)SiriusSWTBotTable.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem tableItem = items[i];
                    if (tableItem.getText().equals(item)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public boolean containsItem(String item) {
        return this.indexOf(item) != -1;
    }

    public int searchText(final String text) {
        final int columnCount = this.columnCount();
        return this.syncExec(new IntResult(){

            public Integer run() {
                TableItem[] items = ((Table)SiriusSWTBotTable.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem tableItem = items[i];
                    int column = 0;
                    while (column < columnCount) {
                        if (tableItem.getText(column).equals(text)) {
                            return i;
                        }
                        ++column;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public boolean containsText(String text) {
        return this.searchText(text) != -1;
    }

    public int indexOf(final String text, final int column) {
        return this.syncExec(new IntResult(){

            public Integer run() {
                TableItem[] items = ((Table)SiriusSWTBotTable.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem tableItem = items[i];
                    if (tableItem.getText(column).equals(text)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }

    public int indexOf(String text, String column) {
        return this.indexOf(text, this.indexOfColumn(column));
    }

    public void unselect() {
        TableItem[] selection;
        this.waitForEnabled();
        this.setFocus();
        this.log.debug((Object)MessageFormat.format((String)"Unselecting all in {0}", (Object[])new Object[]{this}));
        TableItem[] tableItemArray = selection = (TableItem[])this.syncExec((ArrayResult)new ArrayResult<TableItem>(){

            public TableItem[] run() {
                return ((Table)SiriusSWTBotTable.this.widget).getSelection();
            }
        });
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.unselect(item);
            this.notifySelect(true);
            ++n2;
        }
    }

    private void unselect(final TableItem item) {
        this.syncExec(new VoidResult(){

            public void run() {
                ((Table)SiriusSWTBotTable.this.widget).deselect(((Table)SiriusSWTBotTable.this.widget).indexOf(item));
                SiriusSWTBotTable.this.lastSelectionItem = item;
            }
        });
    }

    public void select(int ... indices) {
        this.waitForEnabled();
        if (indices.length > 1) {
            this.assertMultiSelect();
        } else if (indices.length == 0) {
            this.unselect();
            return;
        }
        this.setFocus();
        this.log.debug((Object)MessageFormat.format((String)"Selecting rows {0} in {1}", (Object[])new Object[]{Arrays.toString(indices), this}));
        int i = 0;
        while (i < indices.length) {
            this.assertIsLegalRowIndex(indices[i]);
            ++i;
        }
        ArrayList<TableItem> selection = new ArrayList<TableItem>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selection.add(this.getItem(index));
            ++n2;
        }
        int i2 = 0;
        while (i2 < selection.size()) {
            boolean add = i2 != 0;
            this.processSelection((TableItem)selection.get(i2), add);
            this.notifySelect(add);
            ++i2;
        }
    }

    private void assertMultiSelect() {
        Assert.isLegal((boolean)this.hasStyle(this.widget, 2), (Object)"Table does not support multi selection.");
    }

    private void processSelection(final TableItem item, final boolean add) {
        this.syncExec(new VoidResult(){

            public void run() {
                if (add) {
                    ((Table)SiriusSWTBotTable.this.widget).select(((Table)SiriusSWTBotTable.this.widget).indexOf(item));
                } else {
                    ((Table)SiriusSWTBotTable.this.widget).setSelection(item);
                }
                SiriusSWTBotTable.this.lastSelectionItem = item;
            }
        });
    }

    protected void notifySelect() {
        this.notifySelect(false);
    }

    private void notifySelect(boolean ctrl) {
        int stateMask1 = ctrl ? 262144 : 0;
        int stateMask2 = ctrl ? 786432 : 524288;
        SiriusSWTBotTableItem item = new SiriusSWTBotTableItem(this.lastSelectionItem);
        this.notify(6);
        this.notify(5);
        this.notify(26);
        this.notify(15);
        this.notify(3, item.createMouseEvent(1, stateMask1, 1));
        this.notify(13, item.createSelectionEvent(stateMask2));
        this.notify(4, item.createMouseEvent(1, stateMask2, 1));
    }

    protected Event createSelectionEvent(int stateMask) {
        Event event = super.createSelectionEvent(stateMask);
        event.item = this.lastSelectionItem;
        return event;
    }

    public void click(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        Rectangle cellBounds = (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                TableItem item = ((Table)SiriusSWTBotTable.this.widget).getItem(row);
                Rectangle cellBounds = item.getBounds(column);
                ((Table)SiriusSWTBotTable.this.widget).setSelection(row);
                SiriusSWTBotTable.this.lastSelectionItem = item;
                return cellBounds;
            }
        });
        this.clickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }

    public void doubleClick(final int row, final int column) {
        this.assertIsLegalCell(row, column);
        this.setFocus();
        Rectangle cellBounds = (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                TableItem item = ((Table)SiriusSWTBotTable.this.widget).getItem(row);
                Rectangle cellBounds = item.getBounds(column);
                ((Table)SiriusSWTBotTable.this.widget).setSelection(row);
                SiriusSWTBotTable.this.lastSelectionItem = item;
                return cellBounds;
            }
        });
        this.doubleClickXY(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }

    protected void assertIsLegalCell(int row, int column) {
        int rowCount = this.rowCount();
        int columnCount = this.columnCount();
        Assert.isLegal((row < rowCount ? 1 : 0) != 0, (Object)("The row number (" + row + ") is more than the number of rows(" + rowCount + ") in the table."));
        Assert.isLegal((column < columnCount || columnCount == 0 && column == 0 ? 1 : 0) != 0, (Object)("The column number (" + column + ") is more than the number of column(" + columnCount + ") in the table."));
    }

    public SiriusSWTBotTableItem getTableItem(final String itemText) throws WidgetNotFoundException {
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + itemText;
                }

                public boolean test() throws Exception {
                    return SiriusSWTBotTable.this.getItem(itemText) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for table item " + itemText, (Throwable)e);
        }
        return new SiriusSWTBotTableItem(this.getItem(itemText));
    }

    private TableItem getItem(final String itemText) {
        return (TableItem)this.syncExec((Result)new WidgetResult<TableItem>(){

            public TableItem run() {
                TableItem[] items = ((Table)SiriusSWTBotTable.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    if (item.getText().equals(itemText)) {
                        return item;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public SiriusSWTBotTableItem getTableItem(final int row) throws WidgetNotFoundException {
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find table item for row " + row;
                }

                public boolean test() throws Exception {
                    return SiriusSWTBotTable.this.getItem(row) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for table item in row " + row, (Throwable)e);
        }
        return new SiriusSWTBotTableItem(this.getItem(row));
    }

    private TableItem getItem(final int row) {
        return (TableItem)this.syncExec((Result)new WidgetResult<TableItem>(){

            public TableItem run() {
                return ((Table)SiriusSWTBotTable.this.widget).getItem(row);
            }
        });
    }

    protected Event createMouseEvent(int button, int stateMask, int count) {
        Rectangle bounds = this.getBounds();
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        return this.createMouseEvent(x, y, button, stateMask, count);
    }

    protected Rectangle getBounds() {
        return (Rectangle)this.syncExec((Result)new Result<Rectangle>(){

            public Rectangle run() {
                return ((Table)SiriusSWTBotTable.this.widget).getBounds();
            }
        });
    }

    protected void doubleClickXY(int x, int y) {
        this.log.debug((Object)MessageFormat.format((String)"Double-clicking on {0}", (Object[])new Object[]{this.widget}));
        this.notify(6);
        this.notify(5);
        this.notify(26);
        this.notify(15);
        this.notify(3, this.createMouseEvent(x, y, 1, 0, 1));
        this.notify(13, this.createSelectionEvent(0));
        this.notify(4, this.createMouseEvent(x, y, 1, 524288, 1));
        this.notify(3, this.createMouseEvent(x, y, 1, 0, 2));
        this.notify(13, this.createSelectionEvent(0));
        this.notify(8, this.createMouseEvent(x, y, 1, 0, 2));
        this.notify(14);
        this.notify(4, this.createMouseEvent(x, y, 1, 524288, 2));
        this.notify(32);
        this.notify(5);
        this.notify(7);
        this.notify(27);
        this.notify(16);
        this.log.debug((Object)MessageFormat.format((String)"Double-clicked on {0}", (Object[])new Object[]{this.widget}));
    }
}

