/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Optional;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectPasteModeDialog
extends MessageDialog {
    private static Optional<Boolean> previousPromptResult = Optional.empty();
    private Button absoluteRadioButton;
    private Button boundingBoxRadioButton;
    private boolean rememberState;
    private IPreferenceStore diagUiPreferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();

    public SelectPasteModeDialog(Shell parentShell) {
        super(parentShell, Messages.SelectPasteModeDialog_title, null, Messages.SelectPasteModeDialog_message, 0, new String[]{Messages.SelectPasteModeDialog_pasteButtonLabel, IDialogConstants.CANCEL_LABEL}, 0);
    }

    public static boolean promptIsAbsolutePasteMode(Shell shell) {
        IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
        boolean shouldPrompt = preferenceStore.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name());
        boolean useAbsolutePasteMode = preferenceStore.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name());
        if (!shouldPrompt) {
            return useAbsolutePasteMode;
        }
        if (previousPromptResult.isEmpty()) {
            SelectPasteModeDialog dialog = new SelectPasteModeDialog(shell);
            dialog.open();
            int result = dialog.getReturnCode();
            if (result == 1 || result == -1) {
                throw new OperationCanceledException();
            }
            previousPromptResult = Optional.of(preferenceStore.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name()));
        }
        return previousPromptResult.get();
    }

    public static void tearDownPromptResult() {
        previousPromptResult = Optional.empty();
    }

    protected void buttonPressed(int buttonId) {
        boolean isAbsoluteRadioButtonSelected = this.absoluteRadioButton.getSelection();
        super.buttonPressed(buttonId);
        if (buttonId == 0) {
            if (this.rememberState) {
                this.diagUiPreferenceStore.setValue(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name(), this.rememberState);
            }
            if (isAbsoluteRadioButtonSelected) {
                this.diagUiPreferenceStore.setValue(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name(), true);
            } else {
                this.diagUiPreferenceStore.setValue(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name(), false);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.createToggleButton(dialogAreaComposite);
        return dialogAreaComposite;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        this.absoluteRadioButton = new Button(composite, 16400);
        this.absoluteRadioButton.setText(Messages.SelectPasteModeDialog_absoluteModeLabel);
        this.absoluteRadioButton.setToolTipText(Messages.SelectPasteModeDialog_absoluteModeTooltip);
        this.absoluteRadioButton.setFont(parent.getFont());
        this.boundingBoxRadioButton = new Button(composite, 16400);
        this.boundingBoxRadioButton.setText(Messages.SelectPasteModeDialog_boundingBoxModeLabel);
        this.boundingBoxRadioButton.setToolTipText(Messages.SelectPasteModeDialog_boundingBoxModeTooltip);
        this.boundingBoxRadioButton.setFont(parent.getFont());
        if (this.diagUiPreferenceStore.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name())) {
            this.absoluteRadioButton.setSelection(true);
        } else {
            this.boundingBoxRadioButton.setSelection(true);
        }
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.absoluteRadioButton);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.boundingBoxRadioButton);
        return composite;
    }

    protected Button createToggleButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        Button button = new Button(composite, 16416);
        button.setText(Messages.SelectPasteModeDialog_rememberButtonLabel);
        button.setToolTipText(Messages.SelectPasteModeDialog_rememberButtonTooltip);
        button.setSelection(this.rememberState);
        data = new GridData(0);
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.rememberState = button.getSelection();
        }));
        return button;
    }
}

