/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.tools;

import java.util.Map;
import java.util.Optional;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.ui.SequenceDragEditPartsTrackerEx;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SelectConnectionEditPartTracker;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SequenceMessageSelectConnectionEditPartTracker
extends SelectConnectionEditPartTracker
implements DragTracker {
    private boolean fromTop = true;
    private BendpointRequest bendpointRequest;
    private boolean msgToSelfMove;
    private Optional<Point> initialClick = Optional.empty();

    public SequenceMessageSelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super(owner);
    }

    protected Request createSourceRequest() {
        Request rq = super.createSourceRequest();
        if (rq instanceof BendpointRequest) {
            this.bendpointRequest = (BendpointRequest)rq;
        }
        return rq;
    }

    protected void updateSourceRequest() {
        super.updateSourceRequest();
        if (this.bendpointRequest != null) {
            Map extData = this.bendpointRequest.getExtendedData();
            if (this.msgToSelfMove) {
                extData.put("messageToSelfTopMove", this.fromTop);
            } else {
                extData.remove("messageToSelfTopMove");
            }
            if (this.initialClick.isPresent()) {
                extData.put("messageObliqueChangeBoundsRequestInitialClick", this.initialClick.get());
            } else {
                extData.remove("messageObliqueChangeBoundsRequestInitialClick");
            }
        }
    }

    protected boolean handleButtonDown(int button) {
        boolean res = super.handleButtonDown(button);
        SequenceMessageEditPart smep = (SequenceMessageEditPart)this.getSourceEditPart();
        SequenceDragEditPartsTrackerEx.SequenceCacheDragTrackerHelper.handleButtonDown((IGraphicalEditPart)smep);
        ISequenceEvent iSequenceEvent = smep.getISequenceEvent();
        if (new ISequenceEventQuery(iSequenceEvent).isReflectiveMessage()) {
            Range range = iSequenceEvent.getVerticalRange();
            Point location = this.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)smep);
            Connection connection = smep.getConnectionFigure();
            int x = connection.getPoints().getMidpoint().x;
            if (x == location.x) {
                this.msgToSelfMove = false;
            } else {
                this.fromTop = location.y <= range.getLowerBound() || location.y < range.middleValue();
                this.msgToSelfMove = true;
            }
        } else if (new ISequenceEventQuery(iSequenceEvent).isObliqueMessage() && this.initialClick.isEmpty()) {
            Point location = this.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)smep);
            this.initialClick = Optional.of(location.getCopy());
            Rectangle properLogicalBounds = iSequenceEvent.getProperLogicalBounds();
            this.initialClick.get().x = properLogicalBounds.width < 0 ? (this.initialClick.get().x <= properLogicalBounds.right() - properLogicalBounds.width / 4 ? 1 : (this.initialClick.get().x >= properLogicalBounds.left() + properLogicalBounds.width / 4 ? -1 : 0)) : (this.initialClick.get().x <= properLogicalBounds.left() + properLogicalBounds.width / 4 ? -1 : (this.initialClick.get().x >= properLogicalBounds.right() - properLogicalBounds.width / 4 ? 1 : 0));
        }
        return res;
    }

    protected boolean handleButtonUp(int button) {
        this.initialClick = Optional.empty();
        SequenceDragEditPartsTrackerEx.SequenceCacheDragTrackerHelper.handleButtonUp((IGraphicalEditPart)this.getSourceEditPart());
        return super.handleButtonUp(button);
    }
}

