/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.tests.swtbot.support.api.bot.description.GroupBot;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.view.SiriusPropertiesView;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;

public class SWTBotVSMEditor
extends SWTBotEditor {
    private IPath odesignPath;
    private SiriusPropertiesView propertiesView;

    public SWTBotVSMEditor(IEditorReference reference, SWTWorkbenchBot bot, UIResource sessionResource, SiriusPropertiesView propertiesView) throws WidgetNotFoundException {
        super(reference, bot);
        this.propertiesView = propertiesView;
    }

    public SWTBotVSMEditor(IEditorReference reference, SWTWorkbenchBot bot) throws WidgetNotFoundException {
        super(reference, bot);
        try {
            IEditorInput input = reference.getEditorInput();
            this.odesignPath = this.getPath(input);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private IPath getPath(IEditorInput input) {
        IPath path = null;
        if (input instanceof IFileEditorInput) {
            path = ((IFileEditorInput)input).getFile().getFullPath();
        } else if (input instanceof IPathEditorInput) {
            path = ((IPathEditorInput)input).getPath();
        }
        return path;
    }

    public GroupBot getGroup() {
        SWTBotTree tree = this.bot.treeWithLabel("Resource Set");
        URI diagramURI = URI.createPlatformResourceURI((String)this.odesignPath.toString(), (boolean)true);
        tree.setFocus();
        SWTBotTreeItem treeItem = tree.getTreeItem(diagramURI.toString());
        this.bot.sleep(250L);
        return new GroupBot((SWTBot)this.bot, treeItem.getNode(0).expand(), this.propertiesView);
    }
}

