/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.ide.api;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.ext.ide.api.AbstractRegistryEventListener;
import org.eclipse.sirius.ext.ide.api.IItemDescriptor;
import org.eclipse.sirius.ext.ide.api.IItemRegistry;
import org.eclipse.sirius.ext.ide.api.ItemDescriptor;
import org.eclipse.sirius.ext.ide.internal.Messages;
import org.eclipse.sirius.ext.ide.internal.SiriusExtIdePlugin;

public class DescriptorRegistryEventListener<T>
extends AbstractRegistryEventListener {
    public static final String ID_DESCRIPTOR_ATTR = "id";
    public static final String LABEL_DESCRIPTOR_ATTR = "label";
    public static final String DESCRIPTION_DESCRIPTOR_ATTR = "description";
    public static final String IMPL_CLASS_DESCRIPTOR_ATTR = "class";
    public static final String TAG_DESCRIPTOR = "descriptor";
    private IItemRegistry<T> itemRegistry;

    public DescriptorRegistryEventListener(String namespace, String extensionPointID, IItemRegistry<T> itemRegistry) {
        super(namespace, extensionPointID);
        this.itemRegistry = itemRegistry;
    }

    @Override
    protected boolean validateConfigurationElement(IConfigurationElement configurationElement) {
        boolean isValid = false;
        if (TAG_DESCRIPTOR.equals(configurationElement.getName())) {
            String message;
            if (!this.isValidAttribute(configurationElement, ID_DESCRIPTOR_ATTR)) {
                message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), ID_DESCRIPTOR_ATTR);
                SiriusExtIdePlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ext.ide", message));
            } else if (!this.isValidAttribute(configurationElement, IMPL_CLASS_DESCRIPTOR_ATTR)) {
                message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), IMPL_CLASS_DESCRIPTOR_ATTR);
                SiriusExtIdePlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ext.ide", message));
            } else {
                isValid = true;
            }
            if (!this.isValidAttribute(configurationElement, LABEL_DESCRIPTOR_ATTR)) {
                message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), LABEL_DESCRIPTOR_ATTR);
                SiriusExtIdePlugin.getPlugin().log(new Status(1, "org.eclipse.sirius.ext.ide", message));
            }
            if (!this.isValidAttribute(configurationElement, DESCRIPTION_DESCRIPTOR_ATTR)) {
                message = MessageFormat.format(Messages.DescriptorRegistryEventListener_missingAttribute, configurationElement.getNamespaceIdentifier(), DESCRIPTION_DESCRIPTOR_ATTR);
                SiriusExtIdePlugin.getPlugin().log(new Status(1, "org.eclipse.sirius.ext.ide", message));
            }
        }
        return isValid;
    }

    private boolean isValidAttribute(IConfigurationElement configurationElement, String attributeName) {
        return configurationElement.getAttribute(attributeName) != null && !"".equals(configurationElement.getAttribute(attributeName));
    }

    @Override
    protected boolean processAddition(IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute(ID_DESCRIPTOR_ATTR);
        String label = configurationElement.getAttribute(LABEL_DESCRIPTOR_ATTR);
        String description = configurationElement.getAttribute(DESCRIPTION_DESCRIPTOR_ATTR);
        try {
            Object instance = configurationElement.createExecutableExtension(IMPL_CLASS_DESCRIPTOR_ATTR);
            ItemDescriptor<Object> descriptor = new ItemDescriptor<Object>(id, label, description, instance);
            IItemDescriptor<Object> previous = this.itemRegistry.add(descriptor);
            if (previous != null) {
                String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_extensionAlreadyContributed, configurationElement.getAttribute(ID_DESCRIPTOR_ATTR));
                SiriusExtIdePlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ext.ide", message));
            }
        }
        catch (CoreException e) {
            String message = MessageFormat.format(Messages.DescriptorRegistryEventListener_cannotInstantiateExtension, configurationElement.getAttribute(IMPL_CLASS_DESCRIPTOR_ATTR));
            SiriusExtIdePlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.ext.ide", message, (Throwable)e));
            return false;
        }
        return true;
    }

    @Override
    protected boolean processRemoval(IConfigurationElement configurationElement) {
        return this.itemRegistry.remove(configurationElement.getAttribute(ID_DESCRIPTOR_ATTR)) != null;
    }
}

