/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.NodeStyleQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.RGBValues;

public class InstanceRole
extends AbstractSequenceNode {
    public static final int VISUAL_ID = 2001;

    InstanceRole(Node node) {
        super(node);
        Preconditions.checkArgument((boolean)InstanceRole.notationPredicate().apply((Object)node), (Object)Messages.InstanceRole_nonInstanceRoleNode);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 2001, InstanceRole.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public boolean isExplicitlyCreated() {
        return this.getCreationMessage().some();
    }

    public Option<Message> getCreationMessage() {
        Node node = this.getNotationNode();
        for (Edge edge : Iterables.filter((Iterable)node.getTargetEdges(), Edge.class)) {
            Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
            if (!message.some() || ((Message)message.get()).getKind() != Message.Kind.CREATION) continue;
            return message;
        }
        return Options.newNone();
    }

    @Override
    public Option<Lifeline> getLifeline() {
        Option<Lifeline> result = Options.newNone();
        if (this.cachedLifeline != null) {
            result = this.cachedLifeline;
        } else {
            for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
                Option<Lifeline> lifeline = ISequenceElementAccessor.getLifeline(child);
                if (!lifeline.some()) continue;
                result = lifeline;
                break;
            }
            this.cachedLifeline = result;
        }
        return result;
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        if (this.getNotationNode().getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)this.getNotationNode().getLayoutConstraint();
            return new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
        throw new RuntimeException();
    }

    public String getName() {
        EObject targetElement = this.getNotationNode().getElement();
        if (targetElement instanceof DRepresentationElement) {
            return ((DRepresentationElement)targetElement).getName();
        }
        return "";
    }

    public Option<RGBValues> getBackgroundColor() {
        EObject targetElement = this.getNotationNode().getElement();
        if (targetElement instanceof DNode) {
            return new NodeStyleQuery(((DNode)targetElement).getOwnedStyle()).getBackgroundColor();
        }
        return Options.newNone();
    }

    public Option<RGBValues> getLabelColor() {
        EObject targetElement = this.getNotationNode().getElement();
        if (targetElement instanceof DNode) {
            return new NodeStyleQuery(((DNode)targetElement).getOwnedStyle()).getLabelColor();
        }
        return Options.newNone();
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getInstanceRoleMapping());
        }
    }
}

