/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.representationdescription;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;

public class DescriptionMetamodelsUpdater {
    private static ResourceSet resourceSetCache;
    private EObject description;
    private EReference metamodelEReference;
    protected EditingDomain editingDomain;

    public DescriptionMetamodelsUpdater(EObject description, EReference metamodelEReference) {
        this.description = description;
        this.metamodelEReference = metamodelEReference;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void addEPackagesFromEcoreResource(List<URI> ecoreResourceURIs) {
        List<EPackage> ecoreResourceEPackages = this.getEPackagesFromEcoreResource(ecoreResourceURIs);
        this.addEPackages(ecoreResourceEPackages);
    }

    public void addEPackagesFromURI(List<URI> ePackageURIs) {
        List<EPackage> ePackages = this.getEPackages(ePackageURIs);
        this.addEPackages(ePackages);
    }

    public void addEPackages(List<EPackage> ePackages) {
        if (!ePackages.isEmpty()) {
            Command addEPackagesCmd = AddCommand.create((EditingDomain)this.editingDomain, (Object)this.description, (Object)this.metamodelEReference, ePackages);
            this.editingDomain.getCommandStack().execute(addEPackagesCmd);
        }
    }

    public List<EPackage> getEPackagesFromEcoreResource(List<URI> ecoreResourceURIs) {
        ArrayList<EPackage> ecoreResourceEPackages = new ArrayList<EPackage>();
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        for (URI ecoreResourceURI : ecoreResourceURIs) {
            Resource ecoreResource = resourceSet.getResource(ecoreResourceURI, true);
            ecoreResourceEPackages.addAll(this.getEPackages(ecoreResource));
        }
        return ecoreResourceEPackages;
    }

    public void setDescription(EObject description) {
        this.description = description;
    }

    protected List<EPackage> getEPackages(Resource ecoreResource) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        for (EObject content : ecoreResource.getContents()) {
            if (!(content instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)content;
            ePackages.add(ePackage);
            ePackages.addAll(this.getSubPackages(ePackage));
        }
        return ePackages;
    }

    private List<EPackage> getSubPackages(EPackage ePackage) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ePackages.addAll((Collection<EPackage>)ePackage.getESubpackages());
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            ePackages.addAll((Collection<EPackage>)subEPackage.getESubpackages());
        }
        return ePackages;
    }

    protected Set<Resource> getRelatedResourcesToRemove(List<EPackage> ePackagesToRemove) {
        LinkedHashSet<Resource> relatedResourcesToRemove = new LinkedHashSet<Resource>();
        for (Resource ePackageToRemoveResource : this.getRelatedResources(ePackagesToRemove)) {
            if (ePackageToRemoveResource == null) continue;
            List<EPackage> ePackagesOfResourceToRemove = this.getEPackages(ePackageToRemoveResource);
            Object metamodels = this.description.eGet((EStructuralFeature)this.metamodelEReference);
            if (!(metamodels instanceof Collection) || !Collections.disjoint(ePackagesOfResourceToRemove, (Collection)metamodels)) continue;
            relatedResourcesToRemove.add(ePackageToRemoveResource);
        }
        return relatedResourcesToRemove;
    }

    protected Set<Resource> getRelatedResources(List<EPackage> ePackages) {
        LinkedHashSet<Resource> relatedResources = new LinkedHashSet<Resource>();
        for (EPackage ePackage : ePackages) {
            Resource ePackageResource = ePackage.eResource();
            if (ePackageResource == null) continue;
            relatedResources.add(ePackageResource);
        }
        return relatedResources;
    }

    public List<EPackage> getEPackages(List<URI> ePackageURIs) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        for (URI ePackageURI : ePackageURIs) {
            EObject eObject = resourceSet.getEObject(ePackageURI, true);
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    public void removeEPackages(List<EPackage> ePackages) {
        if (!ePackages.isEmpty()) {
            Command removeEPackagesCmd = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.description, (Object)this.metamodelEReference, ePackages);
            this.editingDomain.getCommandStack().execute(removeEPackagesCmd);
            Set<Resource> relatedResourcesToRemove = this.getRelatedResourcesToRemove(ePackages);
            for (Resource relatedResourceToRemove : relatedResourcesToRemove) {
                this.editingDomain.getResourceSet().getResources().remove((Object)relatedResourceToRemove);
            }
        }
    }

    public List<URI> getURIs(String path, String[] fileNames) {
        ArrayList<URI> uris = new ArrayList<URI>();
        int i = 0;
        int len = fileNames.length;
        while (i < len) {
            URI uri = URI.createFileURI((String)(path + File.separator + fileNames[i]));
            uris.add(uri);
            ++i;
        }
        return uris;
    }

    public List<URI> getURIs(List<IResource> ecoreResources) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (IResource resource : ecoreResources) {
            IPath fullPath = resource.getFullPath();
            URI ecoreResourceURI = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)true);
            uris.add(ecoreResourceURI);
        }
        return uris;
    }

    public List<EPackage> getEPackagesFromNsURI(Object[] result) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        int i = 0;
        int length = result.length;
        while (i < length) {
            EPackage.Descriptor ePackageDescriptor;
            EPackage ePackage;
            Object object = EPackage.Registry.INSTANCE.get(result[i]);
            if (object instanceof EPackage) {
                EPackage ePackage2 = (EPackage)object;
                ePackages.add(ePackage2);
            } else if (object instanceof EPackage.Descriptor && (ePackage = (ePackageDescriptor = (EPackage.Descriptor)object).getEPackage()) != null) {
                ePackages.add(ePackage);
            }
            ++i;
        }
        return ePackages;
    }

    public URI getCompleteURIToEPackage(EPackage ePackage) {
        URI completeURIToEPackage = null;
        Resource ePackageResource = ePackage.eResource();
        URI ePackageResourceURI = ePackageResource.getURI();
        if (!ePackageResourceURI.isPlatform() && !ePackageResourceURI.isFile()) {
            completeURIToEPackage = this.getRealURI(ePackage);
        } else {
            String uriFragment = ePackageResource.getURIFragment((EObject)ePackage);
            completeURIToEPackage = ePackageResourceURI.appendFragment(uriFragment);
        }
        return completeURIToEPackage;
    }

    private URI getRealURI(EPackage ePackage) {
        EPackage realEPackage;
        URI realURI = null;
        this.getResourceSetCache();
        URI genModelResourceURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(ePackage.getNsURI());
        if (genModelResourceURI != null && (realEPackage = this.getEPackageFromCache(ePackage, genModelResourceURI)) != null) {
            Resource ePackageResource = realEPackage.eResource();
            realURI = ePackageResource.getURI().appendFragment(ePackageResource.getURIFragment((EObject)realEPackage));
        }
        return realURI;
    }

    private EPackage getEPackageFromCache(EPackage ePackage, URI genModelResourceURI) {
        EPackage ePackageFromCache = null;
        try {
            this.getResourceSetCache().getResource(genModelResourceURI, true);
        }
        catch (Exception exception) {
            SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.editor", genModelResourceURI.toString() + " not found"));
        }
        EcoreUtil.resolveAll((ResourceSet)this.getResourceSetCache());
        for (Resource resource : this.getResourceSetCache().getResources()) {
            EcoreUtil.resolveAll((Resource)resource);
            EcoreUtil.ContentTreeIterator<Object> treeIterator = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                    return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
                }
            };
            while (treeIterator.hasNext()) {
                Object content = treeIterator.next();
                if (!(content instanceof EPackage)) continue;
                EPackage currentEPackage = (EPackage)content;
                if (!ePackage.getNsURI().equals(currentEPackage.getNsURI())) continue;
                ePackageFromCache = currentEPackage;
                break;
            }
            if (ePackageFromCache != null) break;
        }
        return ePackageFromCache;
    }

    public ResourceSet getResourceSetCache() {
        if (resourceSetCache == null) {
            resourceSetCache = new ResourceSetImpl();
            resourceSetCache.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        }
        return resourceSetCache;
    }

    public void dispose() {
        this.description = null;
        this.metamodelEReference = null;
        this.editingDomain = null;
    }
}

