/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.figures;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.graphical.figures.OverlayLabel;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public final class OverlayLabelsDrawerFigure
extends Figure {
    private final IFigure root;
    private final IGraphicalEditPart part;

    public OverlayLabelsDrawerFigure(IFigure root, IGraphicalEditPart part) {
        this.root = Objects.requireNonNull(root);
        this.part = Objects.requireNonNull(part);
    }

    public Rectangle getBounds() {
        return this.root.getBounds();
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        return null;
    }

    public void paint(Graphics graphics) {
        try {
            OverlayLabel.PAINT_ENABLED.set(true);
            this.paintLabels(graphics, this.root);
        }
        finally {
            OverlayLabel.PAINT_ENABLED.set(false);
        }
    }

    private void paintLabels(Graphics graphics, IFigure figure) {
        if (figure instanceof OverlayLabel) {
            this.paintOverlayLabel(graphics, (OverlayLabel)figure);
        } else {
            ArrayList children = new ArrayList(figure.getChildren());
            for (Object child : children) {
                this.paintLabels(graphics, (IFigure)child);
            }
        }
    }

    private void paintOverlayLabel(Graphics graphics, OverlayLabel label) {
        Rectangle bounds = label.getBounds();
        Point delta = bounds.getTopLeft().getCopy();
        label.translateToAbsolute((Translatable)delta);
        GraphicalHelper.screen2logical((Point)delta, (GraphicalEditPart)this.part);
        delta.translate(bounds.getTopLeft().getNegated());
        graphics.translate(delta.x, delta.y);
        label.paint(graphics);
        graphics.translate(-delta.x, -delta.y);
    }
}

