/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings.table;

import java.util.Collection;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;

public class CandidateMapping {
    private DiagramElementMapping mapping;
    private Layer parentLayer;
    private Collection<Layer> parentLayers;

    public CandidateMapping(DiagramElementMapping mapping) {
        this.mapping = mapping;
        this.parentLayer = this.computeParentLayer();
        this.parentLayers = this.computeParentLayers();
    }

    private Collection<Layer> computeParentLayers() {
        return LayerHelper.getParentLayers(this.mapping);
    }

    private Layer computeParentLayer() {
        DiagramElementMapping current = this.mapping;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)current;
        }
        return null;
    }

    public Layer getParentLayer() {
        return this.parentLayer;
    }

    public Collection<Layer> getParentLayers() {
        return this.parentLayers;
    }

    public DiagramElementMapping getMapping() {
        return this.mapping;
    }
}

