/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.editor.editorPlugin.IAdapterFactoryProvider;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.tools.internal.property.section.SiriusPropertySectionHelper;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEditManager;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationImportDescription;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractViewpointPropertySection
extends AbstractPropertySection {
    public static final int LABEL_WIDTH = 232;
    protected ViewpointPropertySheetPage propertySheetPage;
    protected EObject eObject;
    protected List<EObject> eObjectList;
    protected AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    protected boolean isRequired = false;

    public void createControls(Composite parent, ViewpointPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, (TabbedPropertySheetPage)aTabbedPropertySheetPage);
        this.propertySheetPage = aTabbedPropertySheetPage;
        SiriusEditor editor = this.propertySheetPage.getEditor();
        IWorkbenchPart activePart = editor.getEditorSite().getPage().getActivePart();
        if (activePart instanceof ContentOutline && ((ContentOutline)activePart).getCurrentPage() == editor.getContentOutlinePage()) {
            this.updateSelection(editor.getContentOutlinePage().getSelection());
        } else {
            this.updateSelection(editor.getSelection());
        }
    }

    private boolean updateSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            if (selection instanceof EObject) {
                this.eObject = (EObject)selection;
                return true;
            }
        } else if (((IStructuredSelection)selection).getFirstElement() instanceof EObject) {
            this.eObject = (EObject)((IStructuredSelection)selection).getFirstElement();
            this.eObjectList = ((IStructuredSelection)selection).toList();
            return true;
        }
        return false;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.updateSelection(selection)) {
            this.updateReadOnlyStatus();
        }
    }

    protected void updateReadOnlyStatus() {
        if (this.shouldBeReadOnly()) {
            this.makeReadonly();
        } else {
            this.makeWrittable();
        }
    }

    protected abstract void makeReadonly();

    protected abstract void makeWrittable();

    protected boolean shouldBeReadOnly() {
        RepresentationImportDescription representationImportDescription;
        boolean readonly = false;
        if (this.getFeature() != null) {
            readonly = RepresentationTemplateEditManager.INSTANCE.isOverriden(this.eObject, this.getFeature());
        }
        if ((representationImportDescription = SiriusPropertySectionHelper.getRepresentationImportDescriptionInSelection(this.getSelection())) != null && !SiriusPropertySectionHelper.isChildOfRepresentationDescription(this.eObject, (RepresentationDescription)representationImportDescription)) {
            readonly = true;
        }
        return readonly;
    }

    protected abstract EStructuralFeature getFeature();

    protected AdapterFactoryLabelProvider getAdapterFactoryLabelProvider(EObject eObj) {
        if (this.adapterFactoryLabelProvider == null) {
            if (this.getPart() instanceof IAdapterFactoryProvider) {
                this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(((IAdapterFactoryProvider)this.getPart()).getAdapterFactory());
            } else {
                return new AdapterFactoryLabelProvider(this.rescueAdapterFactory());
            }
        }
        return this.adapterFactoryLabelProvider;
    }

    protected AdapterFactory rescueAdapterFactory() {
        ArrayList<ComposedAdapterFactory> factories = new ArrayList<ComposedAdapterFactory>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        return new ComposedAdapterFactory(factories);
    }

    protected AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        return this.getAdapterFactoryLabelProvider(null);
    }

    protected List<IItemPropertyDescriptor> getDescriptors() {
        AdapterFactory adapterFactory = this.propertySheetPage.getEditor().getAdapterFactory();
        ItemProviderAdapter providerAdapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)this.eObject, IItemPropertySource.class);
        return providerAdapter.getPropertyDescriptors((Object)this.eObject);
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(EStructuralFeature eFeature) {
        for (IItemPropertyDescriptor propertyDescriptor : this.getDescriptors()) {
            if (!((EStructuralFeature)propertyDescriptor.getFeature((Object)this.eObject)).equals(eFeature)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    protected Image getHelpIcon() {
        return SiriusEditor.getImageRegistry().get("icons/full/help.gif");
    }
}

