/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.counting.CrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.HyperedgeCrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.core.options.PortSide;

public final class AllCrossingsCounter
implements IInitializable {
    private CrossingsCounter crossingCounter;
    private boolean[] hasHyperEdgesEastOfIndex;
    private HyperedgeCrossingsCounter hyperedgeCrossingsCounter;
    private int[] inLayerEdgeCounts;
    private boolean[] hasNorthSouthPorts;
    private int nPorts;

    public AllCrossingsCounter(LNode[][] graph) {
        this.inLayerEdgeCounts = new int[graph.length];
        this.hasNorthSouthPorts = new boolean[graph.length];
        this.hasHyperEdgesEastOfIndex = new boolean[graph.length];
        this.nPorts = 0;
    }

    public int countAllCrossings(LNode[][] currentOrder) {
        if (currentOrder.length == 0) {
            return 0;
        }
        int crossings = this.crossingCounter.countInLayerCrossingsOnSide(currentOrder[0], PortSide.WEST);
        crossings += this.crossingCounter.countInLayerCrossingsOnSide(currentOrder[currentOrder.length - 1], PortSide.EAST);
        int layerIndex = 0;
        while (layerIndex < currentOrder.length) {
            crossings += this.countCrossingsAt(layerIndex, currentOrder);
            ++layerIndex;
        }
        return crossings;
    }

    private int countCrossingsAt(int layerIndex, LNode[][] currentOrder) {
        int totalCrossings = 0;
        LNode[] leftLayer = currentOrder[layerIndex];
        if (layerIndex < currentOrder.length - 1) {
            LNode[] rightLayer = currentOrder[layerIndex + 1];
            if (this.hasHyperEdgesEastOfIndex[layerIndex]) {
                totalCrossings = this.hyperedgeCrossingsCounter.countCrossings(leftLayer, rightLayer);
                totalCrossings += this.crossingCounter.countInLayerCrossingsOnSide(leftLayer, PortSide.EAST);
                totalCrossings += this.crossingCounter.countInLayerCrossingsOnSide(rightLayer, PortSide.WEST);
            } else {
                totalCrossings = this.crossingCounter.countCrossingsBetweenLayers(leftLayer, rightLayer);
            }
        }
        if (this.hasNorthSouthPorts[layerIndex]) {
            totalCrossings += this.crossingCounter.countNorthSouthPortCrossingsInLayer(leftLayer);
        }
        return totalCrossings;
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        int n2 = l;
        this.hasNorthSouthPorts[n2] = this.hasNorthSouthPorts[n2] | node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    @Override
    public void initAtPortLevel(int l, int n, int p, LNode[][] nodeOrder) {
        LPort port = nodeOrder[l][n].getPorts().get(p);
        port.id = this.nPorts++;
        if (port.getOutgoingEdges().size() + port.getIncomingEdges().size() > 1) {
            if (port.getSide() == PortSide.EAST) {
                this.hasHyperEdgesEastOfIndex[l] = true;
            } else if (port.getSide() == PortSide.WEST && l > 0) {
                this.hasHyperEdgesEastOfIndex[l - 1] = true;
            }
        }
    }

    @Override
    public void initAtEdgeLevel(int l, int n, int p, int e, LEdge edge, LNode[][] nodeOrder) {
        LPort port = nodeOrder[l][n].getPorts().get(p);
        if (edge.getSource() == port && edge.getSource().getNode().getLayer() == edge.getTarget().getNode().getLayer()) {
            int n2 = l;
            this.inLayerEdgeCounts[n2] = this.inLayerEdgeCounts[n2] + 1;
        }
    }

    @Override
    public void initAfterTraversal() {
        int[] portPos = new int[this.nPorts];
        this.hyperedgeCrossingsCounter = new HyperedgeCrossingsCounter(this.inLayerEdgeCounts, this.hasNorthSouthPorts, portPos);
        this.crossingCounter = new CrossingsCounter(portPos);
    }
}

