/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public class MappingForReconnectToolsConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        ReconnectEdgeDescription red;
        Collection<String> edgeToRegions;
        Resource eObjResource;
        EObject eObj = ctx.getTarget();
        EMFEventType eventType = ctx.getEventType();
        if (eventType == EMFEventType.NULL && (eObjResource = eObj.eResource()) != null && eObjResource.getResourceSet() != null && eObj instanceof ReconnectEdgeDescription && !(edgeToRegions = this.getReconnectOnRegions(red = (ReconnectEdgeDescription)eObj)).isEmpty()) {
            return ctx.createFailureStatus(new Object[]{new IdentifiedElementQuery((IdentifiedElement)red).getLabel(), edgeToRegions});
        }
        return ctx.createSuccessStatus();
    }

    private Collection<String> getReconnectOnRegions(ReconnectEdgeDescription tool) {
        Predicate<ContainerMapping> isRegionMapping = new Predicate<ContainerMapping>(){

            public boolean apply(ContainerMapping input) {
                return new ContainerMappingQuery(input).isRegion();
            }
        };
        LinkedHashSet<EdgeMapping> edgeToRegions = new LinkedHashSet<EdgeMapping>();
        for (EdgeMapping em : tool.getMappings()) {
            if ((tool.getReconnectionKind() == ReconnectionKind.RECONNECT_SOURCE_LITERAL || tool.getReconnectionKind() == ReconnectionKind.RECONNECT_BOTH_LITERAL) && Iterables.any((Iterable)Iterables.filter((Iterable)em.getSourceMapping(), ContainerMapping.class), (Predicate)isRegionMapping)) {
                edgeToRegions.add(em);
            }
            if (tool.getReconnectionKind() != ReconnectionKind.RECONNECT_TARGET_LITERAL && tool.getReconnectionKind() != ReconnectionKind.RECONNECT_BOTH_LITERAL || !Iterables.any((Iterable)Iterables.filter((Iterable)em.getTargetMapping(), ContainerMapping.class), (Predicate)isRegionMapping)) continue;
            edgeToRegions.add(em);
        }
        ArrayList<String> mappingsLabel = new ArrayList<String>();
        for (EdgeMapping mapping : edgeToRegions) {
            mappingsLabel.add(new IdentifiedElementQuery((IdentifiedElement)mapping).getLabel());
        }
        return mappingsLabel;
    }
}

