/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.internal.commands.AbstractCommandProvider;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.parser.ParsingNestedException;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.TemplateProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class CommandlineTemplateProvider
extends AbstractCommandProvider<RuleTemplate>
implements TemplateProvider {
    protected ServiceRegistration tpReg;

    public CommandlineTemplateProvider(BundleContext context) {
        super(context);
    }

    @Override
    public Object addingService(ServiceReference reference) {
        if (reference.getProperty("parser.type").equals("parser.template")) {
            return super.addingService(reference);
        }
        return null;
    }

    public String exportTemplates(String parserType, Set<RuleTemplate> set, File file) throws Exception {
        return super.exportData(parserType, set, file);
    }

    public Set<RuleTemplate> importTemplates(String parserType, URL url) throws IOException, ParsingException {
        Parser parser = (Parser)this.parsers.get(parserType);
        if (parser != null) {
            try (InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(url.openStream()));){
                Set<RuleTemplate> set = this.importData(url, (Parser<RuleTemplate>)parser, inputStreamReader);
                return set;
            }
        }
        throw new ParsingException(new ParsingNestedException(2, null, (Throwable)new Exception("Parser " + parserType + " not available")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleTemplate getTemplate(String UID, Locale locale) {
        Map map = this.providerPortfolio;
        synchronized (map) {
            return (RuleTemplate)this.providedObjectsHolder.get(UID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleTemplate> getTemplates(Locale locale) {
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            return this.providedObjectsHolder.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(URL url) {
        List portfolio = null;
        Map map = this.providerPortfolio;
        synchronized (map) {
            portfolio = (List)this.providerPortfolio.remove(url);
        }
        if (portfolio != null && !portfolio.isEmpty()) {
            map = this.providedObjectsHolder;
            synchronized (map) {
                for (String uid : portfolio) {
                    this.providedObjectsHolder.remove(uid);
                }
            }
        }
        return "SUCCESS";
    }

    @Override
    public void close() {
        if (this.tpReg != null) {
            this.tpReg.unregister();
            this.tpReg = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<RuleTemplate> importData(URL url, Parser<RuleTemplate> parser, InputStreamReader inputStreamReader) throws ParsingException {
        Set providedObjects = parser.parse(inputStreamReader);
        if (providedObjects != null && !providedObjects.isEmpty()) {
            ArrayList<String> portfolio = new ArrayList<String>();
            Map map = this.providerPortfolio;
            synchronized (map) {
                this.providerPortfolio.put(url, portfolio);
            }
            ArrayList<ParsingNestedException> importDataExceptions = new ArrayList<ParsingNestedException>();
            for (RuleTemplate ruleT : providedObjects) {
                ArrayList<ParsingNestedException> exceptions = new ArrayList<ParsingNestedException>();
                String uid = ruleT.getUID();
                this.checkExistence(uid, exceptions);
                if (exceptions.isEmpty()) {
                    portfolio.add(uid);
                    Map map2 = this.providedObjectsHolder;
                    synchronized (map2) {
                        this.providedObjectsHolder.put(uid, ruleT);
                        continue;
                    }
                }
                importDataExceptions.addAll(exceptions);
            }
            if (importDataExceptions.isEmpty()) {
                Hashtable properties = new Hashtable();
                ((Dictionary)properties).put("rule.templates", this.providedObjectsHolder.keySet());
                if (this.tpReg == null) {
                    this.tpReg = this.bc.registerService(TemplateProvider.class.getName(), (Object)this, properties);
                } else {
                    this.tpReg.setProperties(properties);
                }
            } else {
                throw new ParsingException(importDataExceptions);
            }
        }
        return providedObjects;
    }

    protected void checkExistence(String uid, List<ParsingNestedException> exceptions) {
        if (AutomationCommandsPluggable.templateRegistry == null) {
            exceptions.add(new ParsingNestedException(2, uid, (Throwable)new IllegalArgumentException("Failed to create Rule Template with UID \"" + uid + "\"! Can't guarantee yet that other Rule Template with the same UID does not exist.")));
        }
        if (AutomationCommandsPluggable.templateRegistry.get(uid) != null) {
            exceptions.add(new ParsingNestedException(2, uid, (Throwable)new IllegalArgumentException("Rule Template with UID \"" + uid + "\" already exists! Failed to create a second with the same UID!")));
        }
    }
}

