/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.internal.commands.AutomationCommandsPluggable;
import org.eclipse.smarthome.automation.internal.commands.Utils;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.FilterCriteria;
import org.eclipse.smarthome.config.core.ParameterOption;

public class Printer {
    private static final int TABLE_WIDTH = 100;
    private static final int COLUMN_ID = 7;
    private static final int COLUMN_UID = 93;
    private static final int COLUMN_RULE_UID = 36;
    private static final int COLUMN_RULE_NAME = 36;
    private static final int COLUMN_RULE_STATUS = 15;
    private static final int COLUMN_PROPERTY = 28;
    private static final int COLUMN_PROPERTY_VALUE = 72;
    private static final int COLUMN_CONFIG_PARAMETER = 20;
    private static final int COLUMN_CONFIG_PARAMETER_VALUE = 52;
    private static final int COLUMN_CONFIG_PARAMETER_PROP = 16;
    private static final int COLUMN_CONFIG_PARAMETER_PROP_VALUE = 36;
    private static final String ID = "ID";
    private static final String UID = "UID";
    private static final String NAME = "NAME";
    private static final String STATUS = "STATUS";
    private static final String TAGS = "TAGS";
    private static final String LABEL = "LABEL";
    private static final String VISIBILITY = "VISIBILITY";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CONFIGURATION_DESCRIPTIONS = "CONFIGURATION DESCRIPTIONS ";
    private static final String ACTIONS = "ACTIONS";
    private static final String TRIGGERS = "TRIGGERS";
    private static final String CONDITIONS = "CONDITIONS";
    private static final String INPUTS = "INPUTS";
    private static final String OUTPUTS = "OUTPUTS";
    private static final String CHILDREN = "CHILDREN";
    private static final String TYPE = "TYPE";
    private static final String CONFIGURATION = "CONFIGURATION";
    private static final String MIN = "MIN";
    private static final String MAX = "MAX";
    private static final String DEFAULT = "DEFAULT";
    private static final String CONTEXT = "CONTEXT";
    private static final String PATTERN = "PATTERN";
    private static final String OPTIONS = "OPTIONS";
    private static final String STEP_SIZE = "STEP_SIZE";
    private static final String FILTER_CRITERIA = "FILTER CRITERIA ";
    private static final String REQUIRED = "REQUIRED";
    private static final String NOT_REQUIRED = "NOT REQUIRED";

    static String printRules(AutomationCommandsPluggable autoCommands, Map<String, String> ruleUIDs) {
        int[] columnWidths = new int[]{7, 36, 36, 15};
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add(ID);
        columnValues.add(UID);
        columnValues.add(NAME);
        columnValues.add(STATUS);
        String titleRow = Utils.getRow(columnWidths, columnValues);
        ArrayList<String> rulesRows = new ArrayList<String>();
        int i = 1;
        while (i <= ruleUIDs.size()) {
            String id = new Integer(i).toString();
            String uid = ruleUIDs.get(id);
            columnValues.set(0, id);
            columnValues.set(1, uid);
            Rule rule = autoCommands.getRule(uid);
            columnValues.set(2, rule.getName());
            columnValues.set(3, autoCommands.getRuleStatus(uid).toString());
            rulesRows.add(Utils.getRow(columnWidths, columnValues));
            ++i;
        }
        return Utils.getTableContent(100, columnWidths, rulesRows, titleRow);
    }

    static String printTemplates(Map<String, String> templateUIDs) {
        int[] columnWidths = new int[]{7, 93};
        ArrayList<String> columnTitles = new ArrayList<String>();
        columnTitles.add(ID);
        columnTitles.add(UID);
        String titleRow = Utils.getRow(columnWidths, columnTitles);
        ArrayList<String> templates = new ArrayList<String>();
        Printer.collectListRecords(templateUIDs, templates, columnWidths);
        return Utils.getTableContent(100, columnWidths, templates, titleRow);
    }

    static String printModuleTypes(Map<String, String> moduleTypeUIDs) {
        int[] columnWidths = new int[]{7, 93};
        ArrayList<String> columnTitles = new ArrayList<String>();
        columnTitles.add(ID);
        columnTitles.add(UID);
        String titleRow = Utils.getRow(columnWidths, columnTitles);
        ArrayList<String> moduleTypes = new ArrayList<String>();
        Printer.collectListRecords(moduleTypeUIDs, moduleTypes, columnWidths);
        return Utils.getTableContent(100, columnWidths, moduleTypes, titleRow);
    }

    static String printRule(Rule rule, RuleStatus status) {
        int[] columnWidths = new int[]{100};
        ArrayList<String> ruleProperty = new ArrayList<String>();
        ruleProperty.add(String.valueOf(rule.getUID()) + " [ " + status + " ]");
        String titleRow = Utils.getRow(columnWidths, ruleProperty);
        ArrayList<String> ruleContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        ruleProperty.set(0, UID);
        ruleProperty.add(rule.getUID());
        ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        if (rule.getName() != null) {
            ruleProperty.set(0, NAME);
            ruleProperty.set(1, rule.getName());
            ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        }
        if (rule.getDescription() != null) {
            ruleProperty.set(0, DESCRIPTION);
            ruleProperty.set(1, rule.getDescription());
            ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        }
        ruleProperty.set(0, TAGS);
        ruleProperty.set(1, Printer.getTagsRecord(rule.getTags()));
        ruleContent.add(Utils.getRow(columnWidths, ruleProperty));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION, rule.getConfiguration().entrySet()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(rule.getConfigurationDescriptions())));
        ruleContent.addAll(Printer.collectRecords(columnWidths, TRIGGERS, rule.getTriggers()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, CONDITIONS, rule.getConditions()));
        ruleContent.addAll(Printer.collectRecords(columnWidths, ACTIONS, rule.getActions()));
        return Utils.getTableContent(100, columnWidths, ruleContent, titleRow);
    }

    static String printTemplate(Template template) {
        int[] columnWidths = new int[]{100};
        ArrayList<String> templateProperty = new ArrayList<String>();
        templateProperty.add(template.getUID());
        String titleRow = Utils.getRow(columnWidths, templateProperty);
        ArrayList<String> templateContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        templateProperty.set(0, UID);
        templateProperty.add(template.getUID());
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        if (template.getLabel() != null) {
            templateProperty.set(0, LABEL);
            templateProperty.set(1, template.getLabel());
            templateContent.add(Utils.getRow(columnWidths, templateProperty));
        }
        if (template.getDescription() != null) {
            templateProperty.set(0, DESCRIPTION);
            templateProperty.set(1, template.getDescription());
            templateContent.add(Utils.getRow(columnWidths, templateProperty));
        }
        templateProperty.set(0, VISIBILITY);
        templateProperty.set(1, template.getVisibility().toString());
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        templateProperty.set(0, TAGS);
        templateProperty.set(1, Printer.getTagsRecord(template.getTags()));
        templateContent.add(Utils.getRow(columnWidths, templateProperty));
        if (template instanceof RuleTemplate) {
            templateContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(((RuleTemplate)template).getConfigurationDescription())));
            templateContent.addAll(Printer.collectRecords(columnWidths, TRIGGERS, ((RuleTemplate)template).getTriggers()));
            templateContent.addAll(Printer.collectRecords(columnWidths, CONDITIONS, ((RuleTemplate)template).getConditions()));
            templateContent.addAll(Printer.collectRecords(columnWidths, ACTIONS, ((RuleTemplate)template).getActions()));
        }
        return Utils.getTableContent(100, columnWidths, templateContent, titleRow);
    }

    static String printModuleType(ModuleType moduleType) {
        int[] columnWidths = new int[]{100};
        ArrayList<String> moduleTypeProperty = new ArrayList<String>();
        moduleTypeProperty.add(moduleType.getUID());
        String titleRow = Utils.getRow(columnWidths, moduleTypeProperty);
        ArrayList<String> moduleTypeContent = new ArrayList<String>();
        columnWidths = new int[]{28, 72};
        moduleTypeProperty.set(0, UID);
        moduleTypeProperty.add(moduleType.getUID());
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        if (moduleType.getLabel() != null) {
            moduleTypeProperty.set(0, LABEL);
            moduleTypeProperty.set(1, moduleType.getLabel());
            moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        }
        if (moduleType.getDescription() != null) {
            moduleTypeProperty.set(0, DESCRIPTION);
            moduleTypeProperty.set(1, moduleType.getDescription());
            moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        }
        moduleTypeProperty.set(0, VISIBILITY);
        moduleTypeProperty.set(1, moduleType.getVisibility().toString());
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        moduleTypeProperty.set(0, TAGS);
        moduleTypeProperty.set(1, Printer.getTagsRecord(moduleType.getTags()));
        moduleTypeContent.add(Utils.getRow(columnWidths, moduleTypeProperty));
        moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION_DESCRIPTIONS, Printer.getConfigurationDescriptionRecords(moduleType.getConfigurationDescription())));
        if (moduleType instanceof TriggerType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, OUTPUTS, ((TriggerType)moduleType).getOutputs()));
        }
        if (moduleType instanceof ConditionType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, INPUTS, ((ConditionType)moduleType).getInputs()));
        }
        if (moduleType instanceof ActionType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, INPUTS, ((ActionType)moduleType).getInputs()));
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, OUTPUTS, ((ActionType)moduleType).getOutputs()));
        }
        if (moduleType instanceof CompositeTriggerType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, ((CompositeTriggerType)moduleType).getChildren()));
        }
        if (moduleType instanceof CompositeConditionType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, ((CompositeConditionType)moduleType).getChildren()));
        }
        if (moduleType instanceof CompositeActionType) {
            moduleTypeContent.addAll(Printer.collectRecords(columnWidths, CHILDREN, ((CompositeActionType)moduleType).getChildren()));
        }
        return Utils.getTableContent(100, columnWidths, moduleTypeContent, titleRow);
    }

    static String printRuleStatus(String ruleUID, RuleStatus status) {
        ArrayList<String> title = new ArrayList<String>();
        title.add(String.valueOf(ruleUID) + " [ " + status + " ]");
        String titleRow = Utils.getRow(new int[]{100}, title);
        List<String> res = Utils.getTableTitle(titleRow, 100);
        StringBuilder sb = new StringBuilder();
        for (String line : res) {
            sb.append(String.valueOf(line) + "\n");
        }
        return sb.toString();
    }

    private static List<String> collectRecords(int[] columnWidths, String prop, Collection<?> list) {
        ArrayList<String> res = new ArrayList<String>();
        boolean isFirst = true;
        boolean isList = false;
        ArrayList<String> values = new ArrayList<String>();
        values.add(prop);
        values.add("");
        if (list != null && !list.isEmpty()) {
            for (Object element : list) {
                if (element instanceof String) {
                    res.add(String.valueOf(Utils.getColumn(columnWidths[0], (String)values.get(0))) + (String)element);
                    if (!isFirst) continue;
                    isFirst = false;
                    values.set(0, "");
                    continue;
                }
                if (element instanceof Module) {
                    List<String> moduleRecords = Printer.getModuleRecords((Module)element);
                    for (String elementRecord : moduleRecords) {
                        res.add(String.valueOf(Utils.getColumn(columnWidths[0], (String)values.get(0))) + elementRecord);
                        if (!isFirst) continue;
                        isFirst = false;
                        values.set(0, "");
                    }
                    continue;
                }
                isList = true;
                if (isFirst) {
                    values.set(1, "[");
                    res.add(Utils.getRow(columnWidths, values));
                    isFirst = false;
                }
                values.set(0, "");
                if (element instanceof FilterCriteria) {
                    values.set(1, Printer.getFilterCriteriaRecord((FilterCriteria)element));
                } else if (element instanceof ParameterOption) {
                    values.set(1, Printer.getParameterOptionRecord((ParameterOption)element));
                } else if (element instanceof Input) {
                    values.set(1, Printer.getInputRecord((Input)element));
                } else if (element instanceof Output) {
                    values.set(1, Printer.getOutputRecord((Output)element));
                } else if (element instanceof Map.Entry) {
                    values.set(1, "  " + (String)((Map.Entry)element).getKey() + " = \"" + ((Map.Entry)element).getValue().toString() + "\"");
                }
                res.add(Utils.getRow(columnWidths, values));
            }
            if (isList) {
                values.set(0, "");
                values.set(1, "]");
                res.add(Utils.getRow(columnWidths, values));
            }
        }
        return res;
    }

    private static List<String> getModuleRecords(Module module) {
        int[] columnWidths = new int[]{72};
        ArrayList<String> columnValues = new ArrayList<String>();
        columnValues.add(module.getId());
        ArrayList<String> moduleContent = new ArrayList<String>();
        moduleContent.addAll(Utils.getTableTitle(Utils.getRow(columnWidths, columnValues), 72));
        columnWidths = new int[]{20, 52};
        columnValues.set(0, ID);
        columnValues.add(module.getId());
        moduleContent.add(Utils.getRow(columnWidths, columnValues));
        if (module.getLabel() != null) {
            columnValues.set(0, LABEL);
            columnValues.set(1, module.getLabel());
            moduleContent.add(Utils.getRow(columnWidths, columnValues));
        }
        if (module.getDescription() != null) {
            columnValues.set(0, DESCRIPTION);
            columnValues.set(1, module.getDescription());
            moduleContent.add(Utils.getRow(columnWidths, columnValues));
        }
        columnValues.set(0, TYPE);
        columnValues.set(1, module.getTypeUID());
        moduleContent.add(Utils.getRow(columnWidths, columnValues));
        moduleContent.addAll(Printer.collectRecords(columnWidths, CONFIGURATION, module.getConfiguration().entrySet()));
        Map inputs = null;
        if (module instanceof Condition) {
            inputs = ((Condition)module).getInputs();
        }
        if (module instanceof Action) {
            inputs = ((Action)module).getInputs();
        }
        if (inputs != null && !inputs.isEmpty()) {
            moduleContent.addAll(Printer.collectRecords(columnWidths, INPUTS, new ArrayList(inputs.entrySet())));
        }
        return moduleContent;
    }

    private static String getParameterOptionRecord(ParameterOption option) {
        return "  value=\"" + option.getValue() + "\", label=\"" + option.getLabel() + "\"";
    }

    private static String getFilterCriteriaRecord(FilterCriteria criteria) {
        return "  name=\"" + criteria.getName() + "\", value=\"" + criteria.getValue() + "\"";
    }

    private static String getInputRecord(Input input) {
        return "  name=\"" + input.getName() + "\", type=\"" + input.getType() + "\", " + (input.isRequired() ? REQUIRED : NOT_REQUIRED) + (input.getDefaultValue() != null ? "\", default=\"" + input.getDefaultValue() : "");
    }

    private static String getOutputRecord(Output output) {
        return "  name=\"" + output.getName() + "\", type=\"" + output.getType() + "\"";
    }

    private static List<String> getConfigurationDescriptionRecords(List<ConfigDescriptionParameter> configDescriptions) {
        ArrayList<String> configParamContent = new ArrayList<String>();
        if (configDescriptions != null && !configDescriptions.isEmpty()) {
            for (ConfigDescriptionParameter parameter : configDescriptions) {
                int[] columnWidths = new int[]{20, 16, 36};
                configParamContent.add(Utils.getColumn(72, String.valueOf(parameter.getName()) + " : "));
                ArrayList<String> configParamProperty = new ArrayList<String>();
                configParamProperty.add("");
                configParamProperty.add(TYPE);
                configParamProperty.add(parameter.getType().toString());
                configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                if (parameter.getLabel() != null) {
                    configParamProperty.set(1, LABEL);
                    configParamProperty.set(2, parameter.getLabel());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getDescription() != null) {
                    configParamProperty.set(1, DESCRIPTION);
                    configParamProperty.set(2, parameter.getDescription());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getDefault() != null) {
                    configParamProperty.set(1, DEFAULT);
                    configParamProperty.set(2, parameter.getDefault());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getContext() != null) {
                    configParamProperty.set(1, CONTEXT);
                    configParamProperty.set(2, parameter.getContext());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getPattern() != null) {
                    configParamProperty.set(1, PATTERN);
                    configParamProperty.set(2, parameter.getPattern());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getStepSize() != null) {
                    configParamProperty.set(1, STEP_SIZE);
                    configParamProperty.set(2, parameter.getStepSize().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getMinimum() != null) {
                    configParamProperty.set(1, MIN);
                    configParamProperty.set(2, parameter.getMinimum().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                if (parameter.getMaximum() != null) {
                    configParamProperty.set(1, MAX);
                    configParamProperty.set(2, parameter.getMaximum().toString());
                    configParamContent.add(Utils.getRow(columnWidths, configParamProperty));
                }
                columnWidths = new int[]{16, 36};
                List<String> options = Printer.collectRecords(columnWidths, OPTIONS, parameter.getOptions());
                for (String option : options) {
                    configParamContent.add(String.valueOf(Utils.getColumn(20, "")) + option);
                }
                List<String> filters = Printer.collectRecords(columnWidths, FILTER_CRITERIA, parameter.getFilterCriteria());
                for (String filter : filters) {
                    configParamContent.add(String.valueOf(Utils.getColumn(20, "")) + filter);
                }
                configParamContent.add(Utils.getColumn(72, Utils.printChars('-', 72)));
            }
        }
        return configParamContent;
    }

    private static String getTagsRecord(Set<String> tags) {
        if (tags == null || tags.size() == 0) {
            return "[ ]";
        }
        StringBuilder res = new StringBuilder().append("[ ");
        int i = 1;
        for (String tag : tags) {
            if (i < tags.size()) {
                res.append(String.valueOf(tag) + ", ");
            } else {
                res.append(tag);
            }
            ++i;
        }
        return res.append(" ]").toString();
    }

    private static void collectListRecords(Map<String, String> list, List<String> rows, int[] columnWidths) {
        int i = 1;
        while (i <= list.size()) {
            String id = new Integer(i).toString();
            String uid = list.get(id);
            ArrayList<String> columnValues = new ArrayList<String>();
            columnValues.add(id);
            columnValues.add(uid);
            rows.add(Utils.getRow(columnWidths, columnValues));
            ++i;
        }
    }
}

