/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleStatus;
import org.eclipse.smarthome.automation.RuleStatusDetail;
import org.eclipse.smarthome.automation.RuleStatusInfo;
import org.eclipse.smarthome.automation.StatusInfoCallback;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.Connection;
import org.eclipse.smarthome.automation.core.internal.ManagedRuleProvider;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.core.internal.RuleEngineCallbackImpl;
import org.eclipse.smarthome.automation.core.internal.RuntimeAction;
import org.eclipse.smarthome.automation.core.internal.RuntimeCondition;
import org.eclipse.smarthome.automation.core.internal.RuntimeRule;
import org.eclipse.smarthome.automation.core.internal.RuntimeTrigger;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeModuleHandlerFactory;
import org.eclipse.smarthome.automation.core.internal.template.TemplateManager;
import org.eclipse.smarthome.automation.core.internal.type.ModuleTypeManager;
import org.eclipse.smarthome.automation.core.util.ConnectionValidator;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.handler.ModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngine
implements ServiceTrackerCustomizer,
ManagedService {
    public static final char OUTPUT_SEPARATOR = '.';
    public static final String ID_PREFIX = "rule_";
    public static final long DEFAULT_REINITIALIZATION_DELAY = 500L;
    public static final String CONFIG_PROPERTY_REINITIALIZATION_DELAY = "rule.reinitialization.delay";
    private long scheduleReinitializationDelay = 500L;
    private Map<String, RuleEngineCallbackImpl> reCallbacks = new HashMap<String, RuleEngineCallbackImpl>();
    private Map<String, Set<String>> mapModuleTypeToRules = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> mapTemplateToRules = new HashMap<String, Set<String>>();
    private Map<String, RuntimeRule> rules;
    private ServiceTracker mhfTracker;
    BundleContext bc;
    private Map<String, ModuleHandlerFactory> moduleHandlerFactories;
    private boolean isDisposed = false;
    private Map<String, RuleStatusInfo> statusMap = new HashMap<String, RuleStatusInfo>();
    protected Logger logger;
    private StatusInfoCallback statusInfoCallback;
    private Map<String, Map<String, Object>> contextMap;
    private ModuleTypeManager mtManager;
    private TemplateManager tManager;
    private CompositeModuleHandlerFactory compositeFactory;
    private int ruleMaxID = 0;
    private Map<String, Future> scheduleTasks = new HashMap<String, Future>(31);
    private ScheduledExecutorService executor;
    private ManagedRuleProvider managedRuleProvider;

    public RuleEngine(BundleContext bc) {
        this.bc = bc;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.contextMap = new HashMap<String, Map<String, Object>>();
        if (this.rules == null) {
            this.rules = new HashMap<String, RuntimeRule>(20);
        }
        this.moduleHandlerFactories = new HashMap<String, ModuleHandlerFactory>(20);
        this.mhfTracker = new ServiceTracker(bc, ModuleHandlerFactory.class.getName(), (ServiceTrackerCustomizer)this);
        this.mhfTracker.open();
    }

    public Rule addRule(Rule rule, boolean isEnabled) {
        return this.addRule0(rule, isEnabled);
    }

    private Rule addRule0(Rule rule, boolean isEnabled) {
        String rUID = rule.getUID();
        Rule ruleWithUID = rUID == null ? this.initRuleId(rule) : rule;
        RuntimeRule rr = new RuntimeRule(ruleWithUID);
        this.rules.put(rUID, rr);
        this.logger.debug("Added rule '{}'", (Object)rUID);
        this.setRuleEnabled(rUID, isEnabled);
        return this.rules.get(rUID).getRuleCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rule initRuleId(Rule rule) {
        Rule ruleWithUID;
        String rUID = rule.getUID();
        if (rUID == null) {
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                rUID = this.getRuleUID(rUID);
                ruleWithUID = new Rule(rUID, rule.getTriggers(), rule.getConditions(), rule.getActions(), rule.getConfigurationDescriptions(), rule.getConfiguration(), rule.getTemplateUID(), rule.getVisibility());
                ruleWithUID.setName(rule.getName());
                ruleWithUID.setTags(rule.getTags());
                ruleWithUID.setDescription(rule.getDescription());
            }
        } else {
            ruleWithUID = rule;
        }
        return ruleWithUID;
    }

    private void validateModules(List<Module> modules) {
        for (Module m : modules) {
            String mId = m.getId();
            if (mId != null && mId.matches("[A-Za-z0-9_-]*")) continue;
            throw new IllegalArgumentException("Invalid module uid: " + mId != null ? mId : "null. It must not be null or not fit to the pattern: [A-Za-z0-9_-]*");
        }
    }

    String getRuleUID(String rUID) {
        if (rUID != null) {
            if (this.hasRule(rUID)) {
                throw new IllegalArgumentException("Rule '" + rUID + "' already exists.");
            }
        } else {
            rUID = this.getUniqueId();
        }
        return rUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRule(Rule rule) {
        String rUID = rule.getUID();
        boolean isRuleEnabled = false;
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            RuntimeRule r;
            if (rUID == null) {
                rUID = this.getUniqueId();
                r = new RuntimeRule(rule);
                r.setUID(rUID);
                isRuleEnabled = true;
            } else {
                r = this.rules.get(rUID);
                if (r != null) {
                    this.unregister(r);
                }
                r = new RuntimeRule(rule);
            }
            this.rules.put(rUID, r);
            this.logger.debug("Updated rule '{}'.", (Object)rUID);
        }
        if (isRuleEnabled) {
            this.setRuleEnabled(rUID, true);
        }
        if (!RuleStatus.DISABLED.equals((Object)this.getRuleStatus(rUID))) {
            this.setRule(rUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRule(String rUID) {
        if (this.isDisposed) {
            return;
        }
        RuleStatusInfo ruleStatus = null;
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            ruleStatus = this.statusMap.get(rUID);
        }
        if (ruleStatus != null && RuleStatus.NOT_INITIALIZED != ruleStatus.getStatus()) {
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED));
        }
        String errMsgs = null;
        RuntimeRule r = this.getRule0(rUID);
        String templateUID = r.getTemplateUID();
        if (templateUID != null) {
            RuntimeRule notInitializedRule = r;
            try {
                r = this.getRuleByTemplate(r);
            }
            catch (IllegalArgumentException e) {
                errMsgs = "\n Validation of rule " + rUID + " has failed! " + e.getMessage();
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED, RuleStatusDetail.CONFIGURATION_ERROR, errMsgs.trim()));
                r = null;
                return;
            }
            if (r == null) {
                RuleEngine e = this;
                synchronized (e) {
                    Set<String> rules = this.mapTemplateToRules.get(templateUID);
                    if (rules == null) {
                        rules = new HashSet<String>(10);
                    }
                    rules.add(notInitializedRule.getUID());
                    this.mapTemplateToRules.put(templateUID, rules);
                }
                this.logger.warn("The rule: " + rUID + " is not created! The template: " + templateUID + " is not available!");
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED, RuleStatusDetail.TEMPLATE_MISSING_ERROR, "The template: " + templateUID + " is not available!"));
                return;
            }
            RuleEngine e = this;
            synchronized (e) {
                this.rules.put(rUID, r);
            }
            if (this.managedRuleProvider != null && this.managedRuleProvider.get(rUID) != null) {
                this.managedRuleProvider.update(r.getRuleCopy());
            }
        }
        this.autoMapConnections(r);
        List modules = r.getModules(null);
        errMsgs = this.setModuleHandler(rUID, modules);
        if (errMsgs == null) {
            try {
                this.validateModules(modules);
                ConnectionValidator.validateConnections(r);
                this.setDefaultConfigurationValues(modules);
            }
            catch (IllegalArgumentException e) {
                this.unregister(r);
                errMsgs = "\n Validation of rule " + rUID + " has failed! " + e.getMessage();
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED, RuleStatusDetail.CONFIGURATION_ERROR, errMsgs.trim()));
            }
        }
        if (errMsgs == null) {
            this.resolveDefaultValues(r);
            this.register(r);
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.IDLE));
            Future f = this.scheduleTasks.remove(rUID);
            if (f != null && !f.isDone()) {
                f.cancel(true);
            }
            if (this.scheduleTasks.isEmpty() && this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
            }
        } else {
            this.unregister(r);
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED, RuleStatusDetail.HANDLER_INITIALIZING_ERROR, errMsgs));
        }
    }

    private RuntimeRule getRuleByTemplate(RuntimeRule rule) {
        String ruleTemplateUID = rule.getTemplateUID();
        RuleTemplate template = (RuleTemplate)this.tManager.get(ruleTemplateUID);
        if (template == null) {
            this.logger.debug("Rule template '" + ruleTemplateUID + "' does not exist.");
            return null;
        }
        RuntimeRule r1 = new RuntimeRule(rule, template);
        return r1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRuleStatusInfo(String rUID, RuleStatusInfo status) {
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            this.statusMap.put(rUID, status);
        }
        if (this.statusInfoCallback != null) {
            this.statusInfoCallback.statusInfoChanged(rUID, status);
        }
    }

    private <T extends Module> String setModuleHandler(String rUID, List<T> modules) {
        StringBuffer sb = null;
        if (modules != null) {
            for (Module m : modules) {
                this.updateMapModuleTypeToRule(rUID, m.getTypeUID());
                ModuleHandler moduleHandler = this.getModuleHandler(m, rUID);
                if (moduleHandler != null) {
                    if (m instanceof RuntimeAction) {
                        ((RuntimeAction)m).setModuleHandler((ActionHandler)moduleHandler);
                        continue;
                    }
                    if (m instanceof RuntimeCondition) {
                        ((RuntimeCondition)m).setModuleHandler((ConditionHandler)moduleHandler);
                        continue;
                    }
                    if (!(m instanceof RuntimeTrigger)) continue;
                    ((RuntimeTrigger)m).setModuleHandler((TriggerHandler)moduleHandler);
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuffer();
                }
                String message = "Missing handler  '" + m.getTypeUID() + "' for module '" + m.getId() + "'";
                sb.append(message).append("\n");
                this.logger.trace(message);
            }
        }
        return sb != null ? sb.toString() : null;
    }

    private RuleEngineCallbackImpl getRuleEngineCallback(RuntimeRule rule) {
        RuleEngineCallbackImpl result = this.reCallbacks.get(rule.getUID());
        if (result == null) {
            result = new RuleEngineCallbackImpl(this, rule);
            this.reCallbacks.put(rule.getUID(), result);
        }
        return result;
    }

    private <T extends Module> void removeHandlers(List<T> modules, String ruleUID) {
        if (modules != null) {
            for (Module m : modules) {
                ActionHandler handler = null;
                if (m instanceof RuntimeAction) {
                    handler = ((RuntimeAction)m).getModuleHandler();
                } else if (m instanceof RuntimeCondition) {
                    handler = ((RuntimeCondition)m).getModuleHandler();
                } else if (m instanceof RuntimeTrigger) {
                    handler = ((RuntimeTrigger)m).getModuleHandler();
                }
                if (handler == null) continue;
                ModuleHandlerFactory factory = this.getModuleHandlerFactory(m.getTypeUID(), ruleUID);
                if (factory != null) {
                    factory.ungetHandler(m, ruleUID, (ModuleHandler)handler);
                }
                if (m instanceof RuntimeAction) {
                    ((RuntimeAction)m).setModuleHandler(null);
                    continue;
                }
                if (m instanceof RuntimeCondition) {
                    ((RuntimeCondition)m).setModuleHandler(null);
                    continue;
                }
                if (!(m instanceof RuntimeTrigger)) continue;
                ((RuntimeTrigger)m).setModuleHandler(null);
            }
        }
    }

    private void register(RuntimeRule rule) {
        RuleEngineCallbackImpl reCallback = this.getRuleEngineCallback(rule);
        for (RuntimeTrigger t : rule.getTriggers()) {
            TriggerHandler triggerHandler = t.getModuleHandler();
            triggerHandler.setRuleEngineCallback((RuleEngineCallback)reCallback);
        }
    }

    private void unregister(RuntimeRule r) {
        if (r != null) {
            RuleEngineCallbackImpl reCallback = this.reCallbacks.remove(r.getUID());
            if (reCallback != null) {
                reCallback.dispose();
            }
            this.removeHandlers(r.getTriggers(), r.getUID());
            this.removeHandlers(r.getActions(), r.getUID());
            this.removeHandlers(r.getConditions(), r.getUID());
        }
    }

    public ModuleHandler getModuleHandler(Module m, String ruleUID) {
        String moduleTypeId = m.getTypeUID();
        ModuleHandlerFactory mhf = this.getModuleHandlerFactory(moduleTypeId, ruleUID);
        if (mhf == null || this.mtManager.get(moduleTypeId) == null) {
            return null;
        }
        return mhf.getHandler(m, ruleUID);
    }

    public ModuleHandlerFactory getModuleHandlerFactory(String moduleTypeId, String rUID) {
        Object mt;
        ModuleHandlerFactory mhf = this.moduleHandlerFactories.get(moduleTypeId);
        if (mhf == null && ((mt = this.mtManager.get(moduleTypeId)) instanceof CompositeTriggerType || mt instanceof CompositeConditionType || mt instanceof CompositeActionType)) {
            mhf = this.compositeFactory;
        }
        return mhf;
    }

    public synchronized void updateMapModuleTypeToRule(String rUID, String moduleTypeId) {
        Set<String> rules = this.mapModuleTypeToRules.get(moduleTypeId);
        if (rules == null) {
            rules = new HashSet<String>(11);
        }
        rules.add(rUID);
        this.mapModuleTypeToRules.put(moduleTypeId, rules);
    }

    public synchronized boolean removeRule(String id) {
        RuntimeRule r = this.rules.remove(id);
        if (r != null) {
            this.removeRuleEntry(r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuntimeRule removeRuleEntry(RuntimeRule r) {
        this.unregister(r);
        RuleEngine ruleEngine = this;
        synchronized (ruleEngine) {
            Set<String> rules;
            Map.Entry<String, Set<String>> e;
            Iterator<Map.Entry<String, Set<String>>> it = this.mapModuleTypeToRules.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                rules = e.getValue();
                if (rules == null || !rules.contains(r.getUID())) continue;
                rules.remove(r.getUID());
                if (rules.size() >= 1) continue;
                it.remove();
            }
            if (r.getTemplateUID() != null) {
                it = this.mapTemplateToRules.entrySet().iterator();
                while (it.hasNext()) {
                    e = it.next();
                    rules = e.getValue();
                    if (rules == null || !rules.contains(r.getUID())) continue;
                    rules.remove(r.getUID());
                    if (rules.size() >= 1) continue;
                    it.remove();
                }
            }
            this.statusMap.remove(r.getUID());
        }
        return r;
    }

    public synchronized Rule getRule(String rId) {
        RuntimeRule rule = this.rules.get(rId);
        if (rule != null) {
            Rule r = rule.getRuleCopy();
            return r;
        }
        return null;
    }

    private synchronized RuntimeRule getRule0(String rUID) {
        return this.rules.get(rUID);
    }

    public Collection<Rule> getRules() {
        return this.getRulesByTag(null);
    }

    public synchronized Collection<Rule> getRulesByTag(String tag) {
        ArrayList<Rule> result = new ArrayList<Rule>(10);
        for (RuntimeRule r : this.rules.values()) {
            if (tag != null) {
                Set tags = r.getTags();
                if (tags == null || !tags.contains(tag)) continue;
                result.add(r.getRuleCopy());
                continue;
            }
            result.add(r.getRuleCopy());
        }
        return result;
    }

    public synchronized Collection<Rule> getRulesByTags(Set<String> tags) {
        ArrayList<Rule> result = new ArrayList<Rule>(10);
        for (RuntimeRule r : this.rules.values()) {
            if (tags != null) {
                Set rTags = r.getTags();
                if (rTags == null || !rTags.containsAll(tags)) continue;
                result.add(r.getRuleCopy());
                continue;
            }
            result.add(r.getRuleCopy());
        }
        return result;
    }

    public void setRuleEnabled(String rUID, boolean isEnabled) {
        RuleStatus status = this.getRuleStatus(rUID);
        if (status == null) {
            if (isEnabled) {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED));
                this.setRule(rUID);
            } else {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.DISABLED));
            }
        } else if (isEnabled) {
            if (status == RuleStatus.DISABLED) {
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED));
                this.setRule(rUID);
            } else {
                this.logger.info("The rule rId = " + rUID + " is already enabled");
            }
        } else {
            this.unregister(this.getRule0(rUID));
            this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.DISABLED));
        }
    }

    public synchronized boolean hasRule(String rUID) {
        return this.rules.get(rUID) != null;
    }

    public ModuleHandlerFactory addingService(ServiceReference reference) {
        ModuleHandlerFactory mhf = (ModuleHandlerFactory)this.bc.getService(reference);
        Collection moduleTypes = mhf.getTypes();
        this.addNewModuleTypes(mhf, moduleTypes);
        return mhf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewModuleTypes(ModuleHandlerFactory mhf, Collection<String> moduleTypes) {
        Set notInitailizedRules = null;
        for (String moduleTypeName : moduleTypes) {
            Set<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                this.moduleHandlerFactories.put(moduleTypeName, mhf);
                rules = this.mapModuleTypeToRules.get(moduleTypeName);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.NOT_INITIALIZED) continue;
                notInitailizedRules = notInitailizedRules != null ? notInitailizedRules : new HashSet(20);
                notInitailizedRules.add(rUID);
            }
        }
        if (notInitailizedRules != null) {
            for (String rUID : notInitailizedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    private void scheduleRuleInitialization(final String rUID) {
        ScheduledFuture<?> f = this.scheduleTasks.get(rUID);
        if (f == null) {
            ScheduledExecutorService ex = this.getScheduledExecutor();
            f = ex.schedule(new Runnable(){

                @Override
                public void run() {
                    RuleEngine.this.setRule(rUID);
                }
            }, this.scheduleReinitializationDelay, TimeUnit.MILLISECONDS);
            this.scheduleTasks.put(rUID, f);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.logger.debug("ModuleHandlerFactory modified, updating handlers");
        ModuleHandlerFactory moduleHandlerFactory = (ModuleHandlerFactory)service;
        HashSet types = new HashSet(moduleHandlerFactory.getTypes());
        HashSet<String> newTypes = new HashSet<String>(moduleHandlerFactory.getTypes());
        ArrayList<String> removedTypes = new ArrayList<String>();
        for (Map.Entry<String, ModuleHandlerFactory> entry : this.moduleHandlerFactories.entrySet()) {
            if (!entry.getValue().equals(moduleHandlerFactory)) continue;
            String key = entry.getKey();
            if (types.contains(key)) {
                newTypes.remove(key);
                continue;
            }
            removedTypes.add(key);
        }
        if (removedTypes.size() > 0) {
            this.removeMissingModuleTypes(removedTypes);
        }
        if (newTypes.size() > 0) {
            this.addNewModuleTypes(moduleHandlerFactory, newTypes);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        Collection moduleTypes = ((ModuleHandlerFactory)service).getTypes();
        this.removeMissingModuleTypes(moduleTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMissingModuleTypes(Collection<String> moduleTypes) {
        Map mapMissingHandlers = null;
        for (String string : moduleTypes) {
            Set<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                rules = this.mapModuleTypeToRules.get(string);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                switch (ruleStatus) {
                    case IDLE: 
                    case RUNNING: {
                        mapMissingHandlers = mapMissingHandlers != null ? mapMissingHandlers : new HashMap(20);
                        ArrayList<String> list = (ArrayList<String>)mapMissingHandlers.get(rUID);
                        if (list == null) {
                            list = new ArrayList<String>(5);
                        }
                        list.add(string);
                        mapMissingHandlers.put(rUID, list);
                        break;
                    }
                }
            }
        }
        if (mapMissingHandlers != null) {
            for (Map.Entry entry : mapMissingHandlers.entrySet()) {
                String rUID = (String)entry.getKey();
                List missingTypes = (List)entry.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append("Missing handlers: ");
                for (String typeUID : missingTypes) {
                    sb.append(typeUID).append(", ");
                }
                this.unregister(this.getRule0(rUID));
                this.setRuleStatusInfo(rUID, new RuleStatusInfo(RuleStatus.NOT_INITIALIZED, RuleStatusDetail.HANDLER_MISSING_ERROR, sb.substring(0, sb.length() - 2)));
            }
        }
        for (String string : moduleTypes) {
            this.moduleHandlerFactories.remove(string);
        }
    }

    protected void runRule(RuntimeRule rule, RuleEngineCallbackImpl.TriggerData td) {
        RuleStatus ruleStatus = this.getRuleStatus(rule.getUID());
        if (ruleStatus == RuleStatus.IDLE) {
            try {
                this.setRuleStatusInfo(rule.getUID(), new RuleStatusInfo(RuleStatus.RUNNING));
                this.clearContext(rule);
                this.setTriggerOutputs(rule.getUID(), td);
                boolean isSatisfied = this.calculateConditions(rule);
                if (isSatisfied) {
                    this.executeActions(rule);
                    this.logger.debug("The rule '{}' is executed.", (Object)rule.getUID());
                } else {
                    this.logger.debug("The rule '{}' is NOT executed, since it has unsatisfied conditions.", (Object)rule.getUID());
                }
            }
            catch (Throwable t) {
                this.logger.error("Fail to execute rule '{}': {}", (Object)new Object[]{rule.getUID(), t.getMessage()}, (Object)t);
            }
            this.setRuleStatusInfo(rule.getUID(), new RuleStatusInfo(RuleStatus.IDLE));
        } else {
            this.logger.error("Trying to execute rule \u2018{}' with status '{}'", new Object[]{rule.getUID(), ruleStatus.getValue()});
        }
    }

    private void clearContext(RuntimeRule rule) {
        Map<String, Object> context = this.contextMap.get(rule.getUID());
        if (context != null) {
            context.clear();
        }
    }

    private void setTriggerOutputs(String ruleUID, RuleEngineCallbackImpl.TriggerData td) {
        Trigger t = td.getTrigger();
        this.updateContext(ruleUID, t.getId(), td.getOutputs());
    }

    private void updateContext(String ruleUID, String moduleUID, Map<String, ?> outputs) {
        Map<String, Object> context = this.getContext(ruleUID);
        for (Map.Entry<String, ?> entry : outputs.entrySet()) {
            String key = String.valueOf(moduleUID) + '.' + entry.getKey();
            context.put(key, entry.getValue());
        }
    }

    private Map<String, Object> getContext(String ruleUID) {
        return this.getContext(ruleUID, null);
    }

    private Map<String, Object> getContext(String ruleUID, Set<Connection> connections) {
        Map<String, Object> context = this.contextMap.get(ruleUID);
        if (context == null) {
            context = new HashMap<String, Object>();
            this.contextMap.put(ruleUID, context);
        }
        if (connections != null) {
            StringBuffer sb = new StringBuffer();
            for (Connection c : connections) {
                String outputModuleId = c.getOuputModuleId();
                if (outputModuleId != null) {
                    sb.append(outputModuleId).append('.').append(c.getOutputName());
                    context.put(c.getInputName(), context.get(sb.toString()));
                    sb.setLength(0);
                    continue;
                }
                String ref = c.getOutputName();
                Object value = ReferenceResolverUtil.resolveReference(ref, context);
                if (value == null) continue;
                context.put(c.getInputName(), value);
            }
        }
        return context;
    }

    private boolean calculateConditions(Rule rule) {
        List conditions = ((RuntimeRule)rule).getConditions();
        if (conditions == null || conditions.size() == 0) {
            return true;
        }
        for (RuntimeCondition c : conditions) {
            Map<String, Object> context;
            ConditionHandler tHandler = c.getModuleHandler();
            if (tHandler.isSatisfied(context = this.getContext(rule.getUID(), c.getConnections()))) continue;
            this.logger.debug("The condition '{}' of rule '{}' is unsatisfied.", new Object[]{c.getId(), rule.getUID()});
            return false;
        }
        return true;
    }

    private void executeActions(Rule rule) {
        List actions = ((RuntimeRule)rule).getActions();
        if (actions == null || actions.size() == 0) {
            return;
        }
        for (RuntimeAction a : actions) {
            ActionHandler aHandler = a.getModuleHandler();
            try {
                String rUID = rule.getUID();
                Map<String, Object> context = this.getContext(rUID, a.getConnections());
                Map outputs = aHandler.execute(context);
                if (outputs == null) continue;
                context = this.getContext(rUID);
                this.updateContext(rUID, a.getId(), outputs);
            }
            catch (Throwable t) {
                this.logger.error("Fail to execute the action: " + a.getId(), t);
            }
        }
    }

    public synchronized void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            if (this.mhfTracker != null) {
                this.mhfTracker.close();
                this.mhfTracker = null;
            }
            Iterator<RuntimeRule> it = this.rules.values().iterator();
            while (it.hasNext()) {
                RuntimeRule r = it.next();
                this.removeRuleEntry(r);
                it.remove();
            }
            if (this.compositeFactory != null) {
                this.compositeFactory.dispose();
                this.compositeFactory = null;
            }
        }
        for (Future f : this.scheduleTasks.values()) {
            f.cancel(true);
        }
        if (this.scheduleTasks.isEmpty() && this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.scheduleTasks = null;
        if (this.contextMap != null) {
            this.contextMap.clear();
            this.contextMap = null;
        }
        this.statusInfoCallback = null;
    }

    public RuleStatus getRuleStatus(String rUID) {
        RuleStatusInfo info = this.getRuleStatusInfo(rUID);
        RuleStatus status = null;
        if (info != null) {
            status = info.getStatus();
        }
        return status;
    }

    public synchronized RuleStatusInfo getRuleStatusInfo(String rUID) {
        RuleStatusInfo info = this.statusMap.get(rUID);
        return info;
    }

    protected String getUniqueId() {
        return ID_PREFIX + this.getMaxId();
    }

    protected int getMaxId() {
        int result = 0;
        if (this.rules == null) {
            return result;
        }
        Set<String> col = this.rules.keySet();
        if (col != null) {
            for (String rUID : col) {
                if (!rUID.startsWith(ID_PREFIX)) continue;
                String sNum = rUID.substring(ID_PREFIX.length());
                try {
                    int i = Integer.parseInt(sNum);
                    result = i > result ? i : result;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        this.ruleMaxID = result > this.ruleMaxID ? result + 1 : ++this.ruleMaxID;
        return this.ruleMaxID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleTypeUpdated(Collection<ModuleType> moduleTypes) {
        Set notInitailizedRules = null;
        Iterator<ModuleType> it = moduleTypes.iterator();
        while (it.hasNext()) {
            String moduleTypeName = it.next().getUID();
            Set<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                rules = this.mapModuleTypeToRules.get(moduleTypeName);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.NOT_INITIALIZED) continue;
                notInitailizedRules = notInitailizedRules != null ? notInitailizedRules : new HashSet(20);
                notInitailizedRules.add(rUID);
            }
        }
        if (notInitailizedRules != null) {
            for (String rUID : notInitailizedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void templateUpdated(Collection<Template> templates) {
        Set notInitailizedRules = null;
        for (Template template : templates) {
            String templateUID = template.getUID();
            Set<String> rules = null;
            RuleEngine ruleEngine = this;
            synchronized (ruleEngine) {
                rules = this.mapTemplateToRules.get(templateUID);
            }
            if (rules == null) continue;
            for (String rUID : rules) {
                RuleStatus ruleStatus = this.getRuleStatus(rUID);
                if (ruleStatus != RuleStatus.NOT_INITIALIZED) continue;
                notInitailizedRules = notInitailizedRules != null ? notInitailizedRules : new HashSet(20);
                notInitailizedRules.add(rUID);
            }
        }
        if (notInitailizedRules != null) {
            for (String rUID : notInitailizedRules) {
                this.scheduleRuleInitialization(rUID);
            }
        }
    }

    protected void setStatusInfoCallback(StatusInfoCallback statusInfoCallback) {
        this.statusInfoCallback = statusInfoCallback;
    }

    protected void setModuleTypeManager(ModuleTypeManager mtManager) {
        this.mtManager = mtManager;
    }

    protected void setTemplateManager(TemplateManager tManager) {
        this.tManager = tManager;
    }

    protected void setCompositeModuleFactory(CompositeModuleHandlerFactory compositeFactory) {
        this.compositeFactory = compositeFactory;
    }

    private void resolveDefaultValues(RuntimeRule r) {
        this.setDefautlValues(r.getUID(), r.getTriggers());
        this.setDefautlValues(r.getUID(), r.getConditions());
        this.setDefautlValues(r.getUID(), r.getActions());
    }

    private <T extends Module> void setDefautlValues(String ruleUID, List<T> modules) {
        for (Module module : modules) {
            Map moduleConfiguration = module.getConfiguration();
            String typeId = module.getTypeUID();
            Object mt = this.mtManager.get(typeId);
            List configs = mt.getConfigurationDescription();
            if (configs != null) {
                for (ConfigDescriptionParameter config : configs) {
                    String configName;
                    String defaultValue = config.getDefault();
                    if (defaultValue == null || moduleConfiguration.get(configName = config.getName()) != null) continue;
                    moduleConfiguration.put(configName, defaultValue);
                }
            }
            List outputs = null;
            if (mt instanceof TriggerType) {
                outputs = ((TriggerType)mt).getOutputs();
            } else if (mt instanceof ActionType) {
                outputs = ((ActionType)mt).getOutputs();
            }
            if (outputs == null) continue;
            HashMap<String, String> result = new HashMap<String, String>(11);
            for (Output output : outputs) {
                String defaultValue = output.getDefaultValue();
                if (defaultValue == null) continue;
                result.put(output.getName(), defaultValue);
            }
            if (result.size() <= 0) continue;
            this.updateContext(ruleUID, module.getId(), result);
        }
    }

    private ScheduledExecutorService getScheduledExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
        }
        return this.executor;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties != null) {
            Object value = properties.get(CONFIG_PROPERTY_REINITIALIZATION_DELAY);
            if (value != null) {
                if (value instanceof Number) {
                    this.scheduleReinitializationDelay = ((Number)value).longValue();
                } else {
                    this.logger.error("Invalid configuration value: " + value + "It MUST be Number.");
                }
            } else {
                this.scheduleReinitializationDelay = 500L;
            }
        } else {
            this.scheduleReinitializationDelay = 500L;
        }
    }

    private void setDefaultConfigurationValues(List<Module> modules) {
        for (Module module : modules) {
            String type = module.getTypeUID();
            if (this.mtManager != null) {
                Object mt;
                HashMap<String, Object> mConfig = module.getConfiguration();
                if (mConfig == null) {
                    mConfig = new HashMap<String, Object>(11);
                }
                if ((mt = this.mtManager.get(type)) != null) {
                    List configDescriptions = mt.getConfigurationDescription();
                    for (ConfigDescriptionParameter cftDesc : configDescriptions) {
                        String parameterName = cftDesc.getName();
                        if (mConfig.get(parameterName) != null) continue;
                        String strValue = cftDesc.getDefault();
                        if (strValue != null) {
                            ConfigDescriptionParameter.Type t = cftDesc.getType();
                            Object defValue = this.getDefaultValue(t, strValue);
                            mConfig.put(parameterName, defValue);
                            continue;
                        }
                        if (!cftDesc.isRequired()) continue;
                        throw new RuntimeException("Missing required parameter: " + parameterName + " of type " + type);
                    }
                }
                module.setConfiguration(mConfig);
                continue;
            }
            this.logger.warn("Can't get module type definition for:" + type + ". Missing ModuleTypeManager");
        }
    }

    private Object getDefaultValue(ConfigDescriptionParameter.Type type, String value) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case DECIMAL: {
                return new BigDecimal(value);
            }
            case TEXT: {
                return value;
            }
        }
        return null;
    }

    protected void setManagedRuleProvider(ManagedRuleProvider rp) {
        this.managedRuleProvider = rp;
    }

    private void autoMapConnections(RuntimeRule r) {
        Map<String, String> connectionMap;
        Set<Connection> connections;
        HashMap<Set<String>, OutputRef> triggerOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (Trigger t : r.getTriggers()) {
            TriggerType tt = (TriggerType)this.mtManager.get(t.getTypeUID());
            if (tt == null) continue;
            this.initTagsMap(t.getId(), tt.getOutputs(), triggerOutputTags);
        }
        HashMap<Set<String>, OutputRef> actionOutputTags = new HashMap<Set<String>, OutputRef>(11);
        for (Action a : r.getActions()) {
            ActionType at = (ActionType)this.mtManager.get(a.getTypeUID());
            if (at == null) continue;
            this.initTagsMap(a.getId(), at.getOutputs(), actionOutputTags);
        }
        if (!triggerOutputTags.isEmpty()) {
            for (Condition c : r.getConditions()) {
                boolean isConnectionChanged = false;
                ConditionType ct = (ConditionType)this.mtManager.get(c.getTypeUID());
                if (ct == null) continue;
                connections = ((RuntimeCondition)c).getConnections();
                for (Input input : ct.getInputs()) {
                    if (this.isConnected(input, connections) || !this.addAutoMapConnections(input, triggerOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connections = ((RuntimeCondition)c).getConnections();
                connectionMap = this.getConnectionMap(connections);
                c.setInputs(connectionMap);
            }
        }
        if (!triggerOutputTags.isEmpty() || !actionOutputTags.isEmpty()) {
            for (Action a : r.getActions()) {
                boolean isConnectionChanged = false;
                ActionType at = (ActionType)this.mtManager.get(a.getTypeUID());
                if (at == null) continue;
                connections = ((RuntimeAction)a).getConnections();
                for (Input input : at.getInputs()) {
                    if (this.isConnected(input, connections)) continue;
                    if (this.addAutoMapConnections(input, triggerOutputTags, connections)) {
                        isConnectionChanged = true;
                    }
                    if (!this.addAutoMapConnections(input, actionOutputTags, connections)) continue;
                    isConnectionChanged = true;
                }
                if (!isConnectionChanged) continue;
                connections = ((RuntimeAction)a).getConnections();
                connectionMap = this.getConnectionMap(connections);
                a.setInputs(connectionMap);
            }
        }
    }

    private boolean addAutoMapConnections(Input input, Map<Set<String>, OutputRef> outputTagMap, Set<Connection> currentConnections) {
        boolean result = false;
        Set inputTags = input.getTags();
        OutputRef outputRef = null;
        boolean conflict = false;
        if (inputTags.size() > 0) {
            for (Set<String> outTags : outputTagMap.keySet()) {
                if (!outTags.containsAll(inputTags)) continue;
                if (outputRef == null) {
                    outputRef = outputTagMap.get(outTags);
                    continue;
                }
                conflict = true;
                break;
            }
            if (!conflict && outputRef != null) {
                if (currentConnections == null) {
                    currentConnections = new HashSet<Connection>(11);
                }
                currentConnections.add(new Connection(input.getName(), outputRef.getModuleId(), outputRef.getOutputName()));
                result = true;
            }
        }
        return result;
    }

    private void initTagsMap(String moduleId, List<Output> outputs, Map<Set<String>, OutputRef> tagMap) {
        for (Output output : outputs) {
            Set tags = output.getTags();
            if (tags.size() <= 0) continue;
            if (tagMap.get(tags) != null) {
                tagMap.remove(tags);
                continue;
            }
            tagMap.put(tags, new OutputRef(moduleId, output.getName()));
        }
    }

    private boolean isConnected(Input input, Set<Connection> connections) {
        if (connections != null) {
            for (Connection connection : connections) {
                if (!connection.getInputName().equals(input.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, String> getConnectionMap(Set<Connection> connections) {
        HashMap<String, String> connectionMap = new HashMap<String, String>(11);
        for (Connection connection : connections) {
            connectionMap.put(connection.getInputName(), String.valueOf(connection.getOuputModuleId()) + "." + connection.getOutputName());
        }
        return connectionMap;
    }

    class OutputRef {
        private String moduleId;
        private String outputName;

        public OutputRef(String moduleId, String outputName) {
            this.moduleId = moduleId;
            this.outputName = outputName;
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

