/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.core.internal.ReferenceResolverUtil;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.type.ModuleType;

public class AbstractCompositeModuleHandler<M extends Module, MT extends ModuleType, H extends ModuleHandler>
implements ModuleHandler {
    protected LinkedHashMap<M, H> moduleHandlerMap;
    protected M module;
    protected MT moduleType;

    public AbstractCompositeModuleHandler(M module, MT moduleType, LinkedHashMap<M, H> mapModuleToHandler) {
        this.module = module;
        this.moduleType = moduleType;
        this.moduleHandlerMap = mapModuleToHandler;
    }

    protected Map<String, Object> getCompositeContext(Map<String, ?> context) {
        HashMap<String, Object> result = new HashMap<String, Object>(context);
        result.putAll(this.module.getConfiguration());
        return result;
    }

    protected Map<String, Object> getChildContext(Module child, Map<String, ?> compositeContext) {
        return ReferenceResolverUtil.getCompositeChildContext(child, compositeContext);
    }

    public void dispose() {
        if (this.moduleHandlerMap != null) {
            this.moduleHandlerMap.clear();
            this.moduleHandlerMap = null;
        }
    }
}

