/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.handler.ActionHandler;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.Output;

public class CompositeActionHandler
extends AbstractCompositeModuleHandler<Action, CompositeActionType, ActionHandler>
implements ActionHandler {
    public static final String REFERENCE = "reference";
    private Map<String, String> compositeOutputs;

    public CompositeActionHandler(Action action, CompositeActionType mt, LinkedHashMap<Action, ActionHandler> mapModuleToHandler, String ruleUID) {
        super(action, mt, mapModuleToHandler);
        this.compositeOutputs = this.getCompositeOutputMap(((CompositeActionType)this.moduleType).getOutputs());
    }

    public Map<String, Object> execute(Map<String, ?> context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List children = ((CompositeActionType)this.moduleType).getChildren();
        Map<String, Object> compositeContext = this.getCompositeContext(context);
        for (Action child : children) {
            Map<String, Object> childContext;
            ActionHandler childHandler = (ActionHandler)this.moduleHandlerMap.get(child);
            Map childResults = childHandler.execute(childContext = this.getChildContext((Module)child, compositeContext));
            if (childResults == null) continue;
            for (Map.Entry childResult : childResults.entrySet()) {
                String childOuputName = (String)childResult.getKey();
                String childOuputRef = String.valueOf(child.getId()) + "." + childOuputName;
                String compositeOutputName = this.compositeOutputs.get(childOuputRef);
                if (compositeOutputName == null) continue;
                result.put(compositeOutputName, childResult.getValue());
            }
        }
        return result.size() > 0 ? result : null;
    }

    protected Map<String, String> getCompositeOutputMap(List<Output> outputs) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(11);
        if (outputs != null) {
            for (Output output : outputs) {
                String refs = output.getReference();
                if (refs == null) continue;
                StringTokenizer st = new StringTokenizer(refs, ",");
                while (st.hasMoreTokens()) {
                    String ref = st.nextToken().trim();
                    result.put(ref, output.getName());
                }
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

