/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.composite;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.composite.AbstractCompositeModuleHandler;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.Output;

public class CompositeTriggerHandler
extends AbstractCompositeModuleHandler<Trigger, CompositeTriggerType, TriggerHandler>
implements TriggerHandler,
RuleEngineCallback {
    private RuleEngineCallback ruleCallback;

    public CompositeTriggerHandler(Trigger trigger, CompositeTriggerType mt, LinkedHashMap<Trigger, TriggerHandler> mapModuleToHandler, String ruleUID) {
        super(trigger, mt, mapModuleToHandler);
    }

    public void triggered(Trigger trigger, Map<String, ?> context) {
        List outputs = ((CompositeTriggerType)this.moduleType).getOutputs();
        HashMap result = new HashMap(11);
        for (Output output : outputs) {
            String refs = output.getReference();
            if (refs == null) continue;
            StringTokenizer st = new StringTokenizer(refs, ",");
            while (st.hasMoreTokens()) {
                Object value;
                String ref = st.nextToken().trim();
                int i = ref.indexOf(46);
                if (i != -1) {
                    String childModuleId = ref.substring(0, i);
                    if (trigger.getId().equals(childModuleId)) {
                        ref = ref.substring(i + 1);
                    }
                }
                if ((value = context.get(ref)) == null) continue;
                result.put(output.getName(), value);
            }
        }
        this.ruleCallback.triggered((Trigger)this.module, result);
    }

    public void setRuleEngineCallback(RuleEngineCallback ruleCallback) {
        this.ruleCallback = ruleCallback;
        List children = ((CompositeTriggerType)this.moduleType).getChildren();
        for (Trigger child : children) {
            TriggerHandler handler = (TriggerHandler)this.moduleHandlerMap.get(child);
            handler.setRuleEngineCallback((RuleEngineCallback)this);
        }
    }

    @Override
    public void dispose() {
        List children = ((CompositeTriggerType)this.moduleType).getChildren();
        for (Trigger child : children) {
            TriggerHandler handler = (TriggerHandler)this.moduleHandlerMap.get(child);
            handler.setRuleEngineCallback(null);
        }
        this.setRuleEngineCallback(null);
        super.dispose();
    }
}

