/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.handler;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import nl.q42.jue.FullLight;
import nl.q42.jue.HueBridge;
import nl.q42.jue.State;
import nl.q42.jue.StateUpdate;
import org.eclipse.smarthome.binding.hue.HueBindingConstants;
import org.eclipse.smarthome.binding.hue.handler.HueBridgeHandler;
import org.eclipse.smarthome.binding.hue.handler.LightStateConverter;
import org.eclipse.smarthome.binding.hue.handler.LightStatusListener;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingStatusInfo;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HueLightHandler
extends BaseThingHandler
implements LightStatusListener {
    public static final Set<ThingTypeUID> SUPPORTED_THING_TYPES = Sets.newHashSet((Object[])new ThingTypeUID[]{HueBindingConstants.THING_TYPE_LCT001, HueBindingConstants.THING_TYPE_LCT002, HueBindingConstants.THING_TYPE_LCT003, HueBindingConstants.THING_TYPE_LCT007, HueBindingConstants.THING_TYPE_LLC001, HueBindingConstants.THING_TYPE_LLC006, HueBindingConstants.THING_TYPE_LLC007, HueBindingConstants.THING_TYPE_LLC010, HueBindingConstants.THING_TYPE_LLC011, HueBindingConstants.THING_TYPE_LLC012, HueBindingConstants.THING_TYPE_LLC013, HueBindingConstants.THING_TYPE_LWL001, HueBindingConstants.THING_TYPE_LST001, HueBindingConstants.THING_TYPE_LST002, HueBindingConstants.THING_TYPE_LCT003, HueBindingConstants.THING_TYPE_LWB004, HueBindingConstants.THING_TYPE_LWB006, HueBindingConstants.THING_TYPE_LWB007, HueBindingConstants.THING_TYPE_CLASSIC_A60_RGBW, HueBindingConstants.THING_TYPE_SURFACE_LIGHT_TW, HueBindingConstants.THING_TYPE_ZLL_LIGHT, HueBindingConstants.THING_TYPE_LLC020, HueBindingConstants.THING_TYPE_PAR16_50_TW, HueBindingConstants.THING_TYPE_FLEX_RGBW});
    private String lightId;
    private Integer lastSentColorTemp;
    private Integer lastSentBrightness;
    private Logger logger = LoggerFactory.getLogger(HueLightHandler.class);
    private boolean isOsramPar16 = false;
    private HueBridgeHandler bridgeHandler;
    ScheduledFuture<?> scheduledFuture;

    public HueLightHandler(Thing hueLight) {
        super(hueLight);
    }

    public void initialize() {
        this.logger.debug("Initializing hue light handler.");
        String configLightId = (String)this.getConfig().get("lightId");
        if (configLightId != null) {
            this.lightId = configLightId;
            if (this.getHueBridgeHandler() != null) {
                ThingStatusInfo statusInfo = this.getBridge().getStatusInfo();
                this.updateStatus(statusInfo.getStatus(), statusInfo.getStatusDetail(), statusInfo.getDescription());
                FullLight fullLight = this.getLight();
                if (fullLight != null) {
                    this.updateProperty("firmwareVersion", fullLight.getSoftwareVersion());
                    this.isOsramPar16 = HueBindingConstants.THING_TYPE_PAR16_50_TW.equals((Object)this.getThing().getThingTypeUID());
                }
            }
        }
    }

    public void dispose() {
        this.logger.debug("Handler disposes. Unregistering listener.");
        if (this.lightId != null) {
            HueBridgeHandler bridgeHandler = this.getHueBridgeHandler();
            if (bridgeHandler != null) {
                this.getHueBridgeHandler().unregisterLightStatusListener(this);
            }
            this.lightId = null;
        }
    }

    private FullLight getLight() {
        HueBridgeHandler bridgeHandler = this.getHueBridgeHandler();
        if (bridgeHandler != null) {
            return bridgeHandler.getLightById(this.lightId);
        }
        return null;
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        HueBridgeHandler hueBridge = this.getHueBridgeHandler();
        if (hueBridge == null) {
            this.logger.warn("hue bridge handler not found. Cannot handle command without bridge.");
            return;
        }
        FullLight light = this.getLight();
        if (light == null) {
            this.logger.debug("hue light not known on bridge. Cannot handle command.");
            return;
        }
        StateUpdate lightState = null;
        switch (channelUID.getId()) {
            case "color_temperature": {
                if (command instanceof PercentType) {
                    lightState = LightStateConverter.toColorTemperatureLightState((PercentType)command);
                    break;
                }
                if (command instanceof OnOffType) {
                    lightState = LightStateConverter.toOnOffLightState((OnOffType)command);
                    if (!this.isOsramPar16) break;
                    lightState = this.addOsramSpecificCommands(lightState, (OnOffType)command);
                    break;
                }
                if (!(command instanceof IncreaseDecreaseType)) break;
                lightState = this.convertColorTempChangeToStateUpdate((IncreaseDecreaseType)command, light);
                break;
            }
            case "brightness": {
                if (command instanceof PercentType) {
                    lightState = LightStateConverter.toBrightnessLightState((PercentType)command);
                    break;
                }
                if (command instanceof OnOffType) {
                    lightState = LightStateConverter.toOnOffLightState((OnOffType)command);
                    if (!this.isOsramPar16) break;
                    lightState = this.addOsramSpecificCommands(lightState, (OnOffType)command);
                    break;
                }
                if (!(command instanceof IncreaseDecreaseType)) break;
                lightState = this.convertBrightnessChangeToStateUpdate((IncreaseDecreaseType)command, light);
                break;
            }
            case "color": {
                if (command instanceof HSBType) {
                    HSBType hsbCommand = (HSBType)command;
                    if (hsbCommand.getBrightness().intValue() == 0) {
                        lightState = LightStateConverter.toOnOffLightState(OnOffType.OFF);
                        break;
                    }
                    lightState = LightStateConverter.toColorLightState(hsbCommand);
                    break;
                }
                if (command instanceof PercentType) {
                    lightState = LightStateConverter.toBrightnessLightState((PercentType)command);
                    break;
                }
                if (command instanceof OnOffType) {
                    lightState = LightStateConverter.toOnOffLightState((OnOffType)command);
                    break;
                }
                if (!(command instanceof IncreaseDecreaseType)) break;
                lightState = this.convertBrightnessChangeToStateUpdate((IncreaseDecreaseType)command, light);
                break;
            }
            case "alert": {
                if (!(command instanceof StringType)) break;
                lightState = LightStateConverter.toAlertState((StringType)command);
                if (lightState == null) {
                    this.logger.warn("Unsupported String command: {}. Supported commands are: {}, {}, {} ", new Object[]{command, "NONE", "SELECT", "LSELECT"});
                    return;
                }
                this.scheduleAlertStateRestore(command);
                break;
            }
            case "effect": {
                if (!(command instanceof OnOffType)) break;
                lightState = LightStateConverter.toOnOffEffectState((OnOffType)command);
            }
        }
        if (lightState != null) {
            hueBridge.updateLightState(light, lightState);
        } else {
            this.logger.warn("Command send to an unknown channel id: " + channelUID);
        }
    }

    private StateUpdate addOsramSpecificCommands(StateUpdate lightState, OnOffType actionType) {
        if (actionType.equals((Object)OnOffType.ON)) {
            lightState.setBrightness(254);
        } else {
            lightState.setTransitionTime(0);
        }
        return lightState;
    }

    private StateUpdate convertColorTempChangeToStateUpdate(IncreaseDecreaseType command, FullLight light) {
        StateUpdate stateUpdate = null;
        Integer currentColorTemp = this.getCurrentColorTemp(light.getState());
        if (currentColorTemp != null) {
            int newColorTemp = LightStateConverter.toAdjustedColorTemp(command, currentColorTemp);
            stateUpdate = new StateUpdate().setColorTemperature(newColorTemp);
            this.lastSentColorTemp = newColorTemp;
        }
        return stateUpdate;
    }

    private Integer getCurrentColorTemp(State lightState) {
        Integer colorTemp = this.lastSentColorTemp;
        if (colorTemp == null && lightState != null) {
            colorTemp = lightState.getColorTemperature();
        }
        return colorTemp;
    }

    private StateUpdate convertBrightnessChangeToStateUpdate(IncreaseDecreaseType command, FullLight light) {
        StateUpdate stateUpdate = null;
        Integer currentBrightness = this.getCurrentBrightness(light.getState());
        if (currentBrightness != null) {
            int newBrightness = LightStateConverter.toAdjustedBrightness(command, currentBrightness);
            stateUpdate = this.createBrightnessStateUpdate(currentBrightness, newBrightness);
            this.lastSentBrightness = newBrightness;
        }
        return stateUpdate;
    }

    private Integer getCurrentBrightness(State lightState) {
        Integer brightness = this.lastSentBrightness;
        if (brightness == null && lightState != null) {
            brightness = !lightState.isOn() ? Integer.valueOf(0) : Integer.valueOf(lightState.getBrightness());
        }
        return brightness;
    }

    private StateUpdate createBrightnessStateUpdate(int currentBrightness, int newBrightness) {
        StateUpdate lightUpdate = new StateUpdate();
        if (newBrightness == 0) {
            lightUpdate.turnOff();
        } else {
            lightUpdate.setBrightness(newBrightness);
            if (currentBrightness == 0) {
                lightUpdate.turnOn();
            }
        }
        return lightUpdate;
    }

    private synchronized HueBridgeHandler getHueBridgeHandler() {
        if (this.bridgeHandler == null) {
            Bridge bridge = this.getBridge();
            if (bridge == null) {
                return null;
            }
            ThingHandler handler = bridge.getHandler();
            if (handler instanceof HueBridgeHandler) {
                this.bridgeHandler = (HueBridgeHandler)handler;
                this.bridgeHandler.registerLightStatusListener(this);
            } else {
                return null;
            }
        }
        return this.bridgeHandler;
    }

    @Override
    public void onLightStateChanged(HueBridge bridge, FullLight fullLight) {
        if (fullLight != null && fullLight.getId().equals(this.lightId)) {
            this.lastSentColorTemp = null;
            this.lastSentBrightness = null;
            if (fullLight.getState().isReachable()) {
                this.updateStatus(ThingStatus.ONLINE);
            } else {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, "Bridge reports light as not reachable");
            }
            HSBType hsbType = LightStateConverter.toHSBType(fullLight.getState());
            if (!fullLight.getState().isOn()) {
                hsbType = new HSBType(hsbType.getHue(), hsbType.getSaturation(), new PercentType(0));
            }
            this.updateState("color", (org.eclipse.smarthome.core.types.State)hsbType);
            PercentType percentType = LightStateConverter.toColorTemperaturePercentType(fullLight.getState());
            this.updateState("color_temperature", (org.eclipse.smarthome.core.types.State)percentType);
            percentType = LightStateConverter.toBrightnessPercentType(fullLight.getState());
            if (!fullLight.getState().isOn()) {
                percentType = new PercentType(0);
            }
            this.updateState("brightness", (org.eclipse.smarthome.core.types.State)percentType);
            StringType stringType = LightStateConverter.toAlertStringType(fullLight.getState());
            if (!stringType.toString().equals("NULL")) {
                this.updateState("alert", (org.eclipse.smarthome.core.types.State)stringType);
                this.scheduleAlertStateRestore((Command)stringType);
            }
        }
    }

    public void channelLinked(ChannelUID channelUID) {
        HueBridgeHandler handler = this.getHueBridgeHandler();
        if (handler != null) {
            this.onLightStateChanged(null, handler.getLightById(this.lightId));
        }
    }

    @Override
    public void onLightRemoved(HueBridge bridge, FullLight light) {
        if (light.getId().equals(this.lightId)) {
            this.updateStatus(ThingStatus.OFFLINE);
        }
    }

    @Override
    public void onLightAdded(HueBridge bridge, FullLight light) {
        if (light.getId().equals(this.lightId)) {
            this.updateStatus(ThingStatus.ONLINE);
            this.onLightStateChanged(bridge, light);
        }
    }

    private void scheduleAlertStateRestore(Command command) {
        this.cancelScheduledFuture();
        int delay = this.getAlertDuration(command);
        if (delay > 0) {
            this.scheduledFuture = this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    HueLightHandler.this.updateState("alert", (org.eclipse.smarthome.core.types.State)new StringType("NONE"));
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelScheduledFuture() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    private int getAlertDuration(Command command) {
        int delay;
        switch (command.toString()) {
            case "LSELECT": {
                delay = 15000;
                break;
            }
            case "SELECT": {
                delay = 2000;
                break;
            }
            default: {
                delay = -1;
            }
        }
        return delay;
    }
}

